/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Type declarations for the high-level interface to wallet-core.
 *
 * Documentation is auto-generated from this file.
 */

/**
 * Imports.
 */
import {
  AbortTransactionRequest,
  AcceptBankIntegratedWithdrawalRequest,
  AcceptExchangeTosRequest,
  AcceptManualWithdrawalRequest,
  AcceptManualWithdrawalResult,
  AcceptWithdrawalResponse,
  AddExchangeRequest,
  AddGlobalCurrencyAuditorRequest,
  AddGlobalCurrencyExchangeRequest,
  AddKnownBankAccountsRequest,
  AmountResponse,
  ApplyDevExperimentRequest,
  BackupRecovery,
  BalancesResponse,
  CheckPeerPullCreditRequest,
  CheckPeerPullCreditResponse,
  CheckPeerPushDebitRequest,
  CheckPeerPushDebitResponse,
  CoinDumpJson,
  ConfirmPayRequest,
  ConfirmPayResult,
  ConfirmPeerPullDebitRequest,
  ConfirmPeerPushCreditRequest,
  ConvertAmountRequest,
  CreateDepositGroupRequest,
  CreateDepositGroupResponse,
  CreateStoredBackupResponse,
  DeleteExchangeRequest,
  DeleteStoredBackupRequest,
  DeleteTransactionRequest,
  ExchangeDetailedResponse,
  ExchangesListResponse,
  ExchangesShortListResponse,
  FailTransactionRequest,
  ForceRefreshRequest,
  ForgetKnownBankAccountsRequest,
  GetActiveTasks,
  GetAmountRequest,
  GetBalanceDetailRequest,
  GetContractTermsDetailsRequest,
  GetCurrencySpecificationRequest,
  GetCurrencySpecificationResponse,
  GetExchangeEntryByUrlRequest,
  GetExchangeEntryByUrlResponse,
  GetExchangeResourcesRequest,
  GetExchangeResourcesResponse,
  GetExchangeTosRequest,
  GetExchangeTosResult,
  GetPlanForOperationRequest,
  GetPlanForOperationResponse,
  GetWithdrawalDetailsForAmountRequest,
  GetWithdrawalDetailsForUriRequest,
  ImportDbRequest,
  InitRequest,
  InitResponse,
  InitiatePeerPullCreditRequest,
  InitiatePeerPullCreditResponse,
  InitiatePeerPushDebitRequest,
  InitiatePeerPushDebitResponse,
  IntegrationTestArgs,
  KnownBankAccounts,
  ListAssociatedRefreshesRequest,
  ListAssociatedRefreshesResponse,
  ListExchangesForScopedCurrencyRequest,
  ListGlobalCurrencyAuditorsResponse,
  ListGlobalCurrencyExchangesResponse,
  ListKnownBankAccountsRequest,
  PrepareDepositRequest,
  PrepareDepositResponse,
  PreparePayRequest,
  PreparePayResult,
  PreparePayTemplateRequest,
  PreparePeerPullDebitRequest,
  PreparePeerPullDebitResponse,
  PreparePeerPushCreditRequest,
  PreparePeerPushCreditResponse,
  PrepareRefundRequest,
  PrepareWithdrawExchangeRequest,
  PrepareWithdrawExchangeResponse,
  RecoverStoredBackupRequest,
  RecoveryLoadRequest,
  RemoveGlobalCurrencyAuditorRequest,
  RemoveGlobalCurrencyExchangeRequest,
  RetryTransactionRequest,
  SetCoinSuspendedRequest,
  SetWalletDeviceIdRequest,
  SharePaymentRequest,
  SharePaymentResult,
  StartRefundQueryForUriResponse,
  StartRefundQueryRequest,
  StoredBackupList,
  TestPayArgs,
  TestPayResult,
  TestingGetDenomStatsRequest,
  TestingGetDenomStatsResponse,
  TestingListTasksForTransactionRequest,
  TestingListTasksForTransactionsResponse,
  TestingSetTimetravelRequest,
  TestingWaitTransactionRequest,
  Transaction,
  TransactionByIdRequest,
  TransactionWithdrawal,
  TransactionsRequest,
  TransactionsResponse,
  TxIdResponse,
  UpdateExchangeEntryRequest,
  UserAttentionByIdRequest,
  UserAttentionsCountResponse,
  UserAttentionsRequest,
  UserAttentionsResponse,
  ValidateIbanRequest,
  ValidateIbanResponse,
  WalletContractData,
  WalletCoreVersion,
  WithdrawTestBalanceRequest,
  WithdrawUriInfoResponse,
  WithdrawalDetailsForAmount,
  WithdrawalTransactionByURIRequest,
} from "@gnu-taler/taler-util";
import {
  AddBackupProviderRequest,
  AddBackupProviderResponse,
  BackupInfo,
  RemoveBackupProviderRequest,
  RunBackupCycleRequest,
} from "./backup/index.js";
import { PaymentBalanceDetails } from "./balance.js";

export enum WalletApiOperation {
  InitWallet = "initWallet",
  WithdrawTestkudos = "withdrawTestkudos",
  WithdrawTestBalance = "withdrawTestBalance",
  PreparePayForUri = "preparePayForUri",
  SharePayment = "sharePayment",
  PreparePayForTemplate = "preparePayForTemplate",
  GetContractTermsDetails = "getContractTermsDetails",
  RunIntegrationTest = "runIntegrationTest",
  RunIntegrationTestV2 = "runIntegrationTestV2",
  TestCrypto = "testCrypto",
  TestPay = "testPay",
  AddExchange = "addExchange",
  GetTransactions = "getTransactions",
  GetTransactionById = "getTransactionById",
  GetWithdrawalTransactionByUri = "getWithdrawalTransactionByUri",
  TestingGetSampleTransactions = "testingGetSampleTransactions",
  ListExchanges = "listExchanges",
  GetExchangeEntryByUrl = "getExchangeEntryByUrl",
  ListKnownBankAccounts = "listKnownBankAccounts",
  AddKnownBankAccounts = "addKnownBankAccounts",
  ForgetKnownBankAccounts = "forgetKnownBankAccounts",
  GetWithdrawalDetailsForUri = "getWithdrawalDetailsForUri",
  GetWithdrawalDetailsForAmount = "getWithdrawalDetailsForAmount",
  AcceptManualWithdrawal = "acceptManualWithdrawal",
  GetBalances = "getBalances",
  GetBalanceDetail = "getBalanceDetail",
  GetPlanForOperation = "getPlanForOperation",
  ConvertDepositAmount = "ConvertDepositAmount",
  GetMaxDepositAmount = "GetMaxDepositAmount",
  ConvertPeerPushAmount = "ConvertPeerPushAmount",
  GetMaxPeerPushAmount = "GetMaxPeerPushAmount",
  ConvertWithdrawalAmount = "ConvertWithdrawalAmount",
  GetUserAttentionRequests = "getUserAttentionRequests",
  GetUserAttentionUnreadCount = "getUserAttentionUnreadCount",
  MarkAttentionRequestAsRead = "markAttentionRequestAsRead",
  GetPendingOperations = "getPendingOperations",
  GetActiveTasks = "getActiveTasks",
  SetExchangeTosAccepted = "setExchangeTosAccepted",
  SetExchangeTosForgotten = "SetExchangeTosForgotten",
  StartRefundQueryForUri = "startRefundQueryForUri",
  StartRefundQuery = "startRefundQuery",
  AcceptBankIntegratedWithdrawal = "acceptBankIntegratedWithdrawal",
  GetExchangeTos = "getExchangeTos",
  GetExchangeDetailedInfo = "getExchangeDetailedInfo",
  RetryPendingNow = "retryPendingNow",
  AbortTransaction = "abortTransaction",
  FailTransaction = "failTransaction",
  SuspendTransaction = "suspendTransaction",
  ResumeTransaction = "resumeTransaction",
  DeleteTransaction = "deleteTransaction",
  RetryTransaction = "retryTransaction",
  ConfirmPay = "confirmPay",
  DumpCoins = "dumpCoins",
  SetCoinSuspended = "setCoinSuspended",
  ForceRefresh = "forceRefresh",
  ExportBackup = "exportBackup",
  AddBackupProvider = "addBackupProvider",
  RemoveBackupProvider = "removeBackupProvider",
  RunBackupCycle = "runBackupCycle",
  ExportBackupRecovery = "exportBackupRecovery",
  ImportBackupRecovery = "importBackupRecovery",
  GetBackupInfo = "getBackupInfo",
  PrepareDeposit = "prepareDeposit",
  GetVersion = "getVersion",
  GenerateDepositGroupTxId = "generateDepositGroupTxId",
  CreateDepositGroup = "createDepositGroup",
  SetWalletDeviceId = "setWalletDeviceId",
  ImportDb = "importDb",
  ExportDb = "exportDb",
  PreparePeerPushCredit = "preparePeerPushCredit",
  CheckPeerPushDebit = "checkPeerPushDebit",
  InitiatePeerPushDebit = "initiatePeerPushDebit",
  ConfirmPeerPushCredit = "confirmPeerPushCredit",
  CheckPeerPullCredit = "checkPeerPullCredit",
  InitiatePeerPullCredit = "initiatePeerPullCredit",
  PreparePeerPullDebit = "preparePeerPullDebit",
  ConfirmPeerPullDebit = "confirmPeerPullDebit",
  ClearDb = "clearDb",
  Recycle = "recycle",
  ApplyDevExperiment = "applyDevExperiment",
  ValidateIban = "validateIban",
  TestingWaitTransactionsFinal = "testingWaitTransactionsFinal",
  TestingWaitRefreshesFinal = "testingWaitRefreshesFinal",
  TestingWaitTransactionState = "testingWaitTransactionState",
  TestingSetTimetravel = "testingSetTimetravel",
  GetCurrencySpecification = "getCurrencySpecification",
  ListStoredBackups = "listStoredBackups",
  CreateStoredBackup = "createStoredBackup",
  DeleteStoredBackup = "deleteStoredBackup",
  RecoverStoredBackup = "recoverStoredBackup",
  UpdateExchangeEntry = "updateExchangeEntry",
  ListExchangesForScopedCurrency = "listExchangesForScopedCurrency",
  PrepareWithdrawExchange = "prepareWithdrawExchange",
  TestingInfiniteTransactionLoop = "testingInfiniteTransactionLoop",
  GetExchangeResources = "getExchangeResources",
  DeleteExchange = "deleteExchange",
  ListGlobalCurrencyExchanges = "listGlobalCurrencyExchanges",
  ListGlobalCurrencyAuditors = "listGlobalCurrencyAuditors",
  AddGlobalCurrencyExchange = "addGlobalCurrencyExchange",
  RemoveGlobalCurrencyExchange = "removeGlobalCurrencyExchange",
  AddGlobalCurrencyAuditor = "addGlobalCurrencyAuditor",
  RemoveGlobalCurrencyAuditor = "removeGlobalCurrencyAuditor",
  ListAssociatedRefreshes = "listAssociatedRefreshes",
  TestingListTaskForTransaction = "testingListTasksForTransaction",
  TestingGetDenomStats = "testingGetDenomStats",
}

// group: Initialization

type EmptyObject = Record<string, never>;
/**
 * Initialize wallet-core.
 *
 * Must be the request before any other operations.
 */
export type InitWalletOp = {
  op: WalletApiOperation.InitWallet;
  request: InitRequest;
  response: InitResponse;
};

export type GetVersionOp = {
  op: WalletApiOperation.GetVersion;
  request: EmptyObject;
  response: WalletCoreVersion;
};

// group: Basic Wallet Information

/**
 * Get current wallet balance.
 */
export type GetBalancesOp = {
  op: WalletApiOperation.GetBalances;
  request: EmptyObject;
  response: BalancesResponse;
};
export type GetBalancesDetailOp = {
  op: WalletApiOperation.GetBalanceDetail;
  request: GetBalanceDetailRequest;
  response: PaymentBalanceDetails;
};

export type GetPlanForOperationOp = {
  op: WalletApiOperation.GetPlanForOperation;
  request: GetPlanForOperationRequest;
  response: GetPlanForOperationResponse;
};

export type ConvertDepositAmountOp = {
  op: WalletApiOperation.ConvertDepositAmount;
  request: ConvertAmountRequest;
  response: AmountResponse;
};
export type GetMaxDepositAmountOp = {
  op: WalletApiOperation.GetMaxDepositAmount;
  request: GetAmountRequest;
  response: AmountResponse;
};
export type ConvertPeerPushAmountOp = {
  op: WalletApiOperation.ConvertPeerPushAmount;
  request: ConvertAmountRequest;
  response: AmountResponse;
};
export type GetMaxPeerPushAmountOp = {
  op: WalletApiOperation.GetMaxPeerPushAmount;
  request: GetAmountRequest;
  response: AmountResponse;
};
export type ConvertWithdrawalAmountOp = {
  op: WalletApiOperation.ConvertWithdrawalAmount;
  request: ConvertAmountRequest;
  response: AmountResponse;
};

// group: Managing Transactions

/**
 * Get transactions.
 */
export type GetTransactionsOp = {
  op: WalletApiOperation.GetTransactions;
  request: TransactionsRequest;
  response: TransactionsResponse;
};

/**
 * List refresh transactions associated with another transaction.
 */
export type ListAssociatedRefreshesOp = {
  op: WalletApiOperation.ListAssociatedRefreshes;
  request: ListAssociatedRefreshesRequest;
  response: ListAssociatedRefreshesResponse;
};

/**
 * Get sample transactions.
 */
export type TestingGetSampleTransactionsOp = {
  op: WalletApiOperation.TestingGetSampleTransactions;
  request: EmptyObject;
  response: TransactionsResponse;
};

export type GetTransactionByIdOp = {
  op: WalletApiOperation.GetTransactionById;
  request: TransactionByIdRequest;
  response: Transaction;
};

export type GetWithdrawalTransactionByUriOp = {
  op: WalletApiOperation.GetWithdrawalTransactionByUri;
  request: WithdrawalTransactionByURIRequest;
  response: TransactionWithdrawal | undefined;
};

export type RetryPendingNowOp = {
  op: WalletApiOperation.RetryPendingNow;
  request: EmptyObject;
  response: EmptyObject;
};

/**
 * Delete a transaction locally in the wallet.
 */
export type DeleteTransactionOp = {
  op: WalletApiOperation.DeleteTransaction;
  request: DeleteTransactionRequest;
  response: EmptyObject;
};

/**
 * Immediately retry a transaction.
 */
export type RetryTransactionOp = {
  op: WalletApiOperation.RetryTransaction;
  request: RetryTransactionRequest;
  response: EmptyObject;
};

/**
 * Abort a transaction
 *
 * For payment transactions, it puts the payment into an "aborting" state.
 */
export type AbortTransactionOp = {
  op: WalletApiOperation.AbortTransaction;
  request: AbortTransactionRequest;
  response: EmptyObject;
};

/**
 * Cancel aborting a transaction
 *
 * For payment transactions, it puts the payment into an "aborting" state.
 */
export type FailTransactionOp = {
  op: WalletApiOperation.FailTransaction;
  request: FailTransactionRequest;
  response: EmptyObject;
};

/**
 * Suspend a transaction
 */
export type SuspendTransactionOp = {
  op: WalletApiOperation.SuspendTransaction;
  request: AbortTransactionRequest;
  response: EmptyObject;
};

/**
 * Resume a transaction
 */
export type ResumeTransactionOp = {
  op: WalletApiOperation.ResumeTransaction;
  request: AbortTransactionRequest;
  response: EmptyObject;
};

// group: Withdrawals

/**
 * Get details for withdrawing a particular amount (manual withdrawal).
 */
export type GetWithdrawalDetailsForAmountOp = {
  op: WalletApiOperation.GetWithdrawalDetailsForAmount;
  request: GetWithdrawalDetailsForAmountRequest;
  response: WithdrawalDetailsForAmount;
};

/**
 * Get details for withdrawing via a particular taler:// URI.
 */
export type GetWithdrawalDetailsForUriOp = {
  op: WalletApiOperation.GetWithdrawalDetailsForUri;
  request: GetWithdrawalDetailsForUriRequest;
  response: WithdrawUriInfoResponse;
};

/**
 * Accept a bank-integrated withdrawal.
 */
export type AcceptBankIntegratedWithdrawalOp = {
  op: WalletApiOperation.AcceptBankIntegratedWithdrawal;
  request: AcceptBankIntegratedWithdrawalRequest;
  response: AcceptWithdrawalResponse;
};

/**
 * Create a manual withdrawal.
 */
export type AcceptManualWithdrawalOp = {
  op: WalletApiOperation.AcceptManualWithdrawal;
  request: AcceptManualWithdrawalRequest;
  response: AcceptManualWithdrawalResult;
};

// group: Merchant Payments

/**
 * Prepare to make a payment based on a taler://pay/ URI.
 */
export type PreparePayForUriOp = {
  op: WalletApiOperation.PreparePayForUri;
  request: PreparePayRequest;
  response: PreparePayResult;
};

export type SharePaymentOp = {
  op: WalletApiOperation.SharePayment;
  request: SharePaymentRequest;
  response: SharePaymentResult;
};

/**
 * Prepare to make a payment based on a taler://pay-template/ URI.
 */
export type PreparePayForTemplateOp = {
  op: WalletApiOperation.PreparePayForTemplate;
  request: PreparePayTemplateRequest;
  response: PreparePayResult;
};

export type GetContractTermsDetailsOp = {
  op: WalletApiOperation.GetContractTermsDetails;
  request: GetContractTermsDetailsRequest;
  response: WalletContractData;
};

/**
 * Confirm a payment that was previously prepared with
 * {@link PreparePayForUriOp}
 */
export type ConfirmPayOp = {
  op: WalletApiOperation.ConfirmPay;
  request: ConfirmPayRequest;
  response: ConfirmPayResult;
};

/**
 * Check for a refund based on a taler://refund URI.
 */
export type StartRefundQueryForUriOp = {
  op: WalletApiOperation.StartRefundQueryForUri;
  request: PrepareRefundRequest;
  response: StartRefundQueryForUriResponse;
};

export type StartRefundQueryOp = {
  op: WalletApiOperation.StartRefundQuery;
  request: StartRefundQueryRequest;
  response: EmptyObject;
};

// group: Global Currency management

export type ListGlobalCurrencyAuditorsOp = {
  op: WalletApiOperation.ListGlobalCurrencyAuditors;
  request: EmptyObject;
  response: ListGlobalCurrencyAuditorsResponse;
};

export type ListGlobalCurrencyExchangesOp = {
  op: WalletApiOperation.ListGlobalCurrencyExchanges;
  request: EmptyObject;
  response: ListGlobalCurrencyExchangesResponse;
};

export type AddGlobalCurrencyExchangeOp = {
  op: WalletApiOperation.AddGlobalCurrencyExchange;
  request: AddGlobalCurrencyExchangeRequest;
  response: EmptyObject;
};

export type AddGlobalCurrencyAuditorOp = {
  op: WalletApiOperation.AddGlobalCurrencyAuditor;
  request: AddGlobalCurrencyAuditorRequest;
  response: EmptyObject;
};

export type RemoveGlobalCurrencyExchangeOp = {
  op: WalletApiOperation.RemoveGlobalCurrencyExchange;
  request: RemoveGlobalCurrencyExchangeRequest;
  response: EmptyObject;
};

export type RemoveGlobalCurrencyAuditorOp = {
  op: WalletApiOperation.RemoveGlobalCurrencyAuditor;
  request: RemoveGlobalCurrencyAuditorRequest;
  response: EmptyObject;
};

// group: Exchange Management

/**
 * List exchanges known to the wallet.
 */
export type ListExchangesOp = {
  op: WalletApiOperation.ListExchanges;
  request: EmptyObject;
  response: ExchangesListResponse;
};

/**
 * List exchanges that are available for withdrawing a particular
 * scoped currency.
 */
export type ListExchangesForScopedCurrencyOp = {
  op: WalletApiOperation.ListExchangesForScopedCurrency;
  request: ListExchangesForScopedCurrencyRequest;
  response: ExchangesShortListResponse;
};

/**
 * Prepare for withdrawing via a taler://withdraw-exchange URI.
 */
export type PrepareWithdrawExchangeOp = {
  op: WalletApiOperation.PrepareWithdrawExchange;
  request: PrepareWithdrawExchangeRequest;
  response: PrepareWithdrawExchangeResponse;
};

/**
 * Add / force-update an exchange.
 */
export type AddExchangeOp = {
  op: WalletApiOperation.AddExchange;
  request: AddExchangeRequest;
  response: EmptyObject;
};

/**
 * Update an exchange entry.
 */
export type UpdateExchangeEntryOp = {
  op: WalletApiOperation.UpdateExchangeEntry;
  request: UpdateExchangeEntryRequest;
  response: EmptyObject;
};

export type ListKnownBankAccountsOp = {
  op: WalletApiOperation.ListKnownBankAccounts;
  request: ListKnownBankAccountsRequest;
  response: KnownBankAccounts;
};

export type AddKnownBankAccountsOp = {
  op: WalletApiOperation.AddKnownBankAccounts;
  request: AddKnownBankAccountsRequest;
  response: EmptyObject;
};

export type ForgetKnownBankAccountsOp = {
  op: WalletApiOperation.ForgetKnownBankAccounts;
  request: ForgetKnownBankAccountsRequest;
  response: EmptyObject;
};

/**
 * Accept a particular version of the exchange terms of service.
 */
export type SetExchangeTosAcceptedOp = {
  op: WalletApiOperation.SetExchangeTosAccepted;
  request: AcceptExchangeTosRequest;
  response: EmptyObject;
};

/**
 * Accept a particular version of the exchange terms of service.
 */
export type SetExchangeTosForgottenOp = {
  op: WalletApiOperation.SetExchangeTosForgotten;
  request: AcceptExchangeTosRequest;
  response: EmptyObject;
};

/**
 * Get the current terms of a service of an exchange.
 */
export type GetExchangeTosOp = {
  op: WalletApiOperation.GetExchangeTos;
  request: GetExchangeTosRequest;
  response: GetExchangeTosResult;
};

/**
 * Get the current terms of a service of an exchange.
 */
export type GetExchangeDetailedInfoOp = {
  op: WalletApiOperation.GetExchangeDetailedInfo;
  request: AddExchangeRequest;
  response: ExchangeDetailedResponse;
};

/**
 * Get the current terms of a service of an exchange.
 */
export type GetExchangeEntryByUrlOp = {
  op: WalletApiOperation.GetExchangeEntryByUrl;
  request: GetExchangeEntryByUrlRequest;
  response: GetExchangeEntryByUrlResponse;
};

/**
 * Get resources associated with an exchange.
 */
export type GetExchangeResourcesOp = {
  op: WalletApiOperation.GetExchangeResources;
  request: GetExchangeResourcesRequest;
  response: GetExchangeResourcesResponse;
};

/**
 * Get resources associated with an exchange.
 */
export type DeleteExchangeOp = {
  op: WalletApiOperation.GetExchangeResources;
  request: DeleteExchangeRequest;
  response: EmptyObject;
};

export type GetCurrencySpecificationOp = {
  op: WalletApiOperation.GetCurrencySpecification;
  request: GetCurrencySpecificationRequest;
  response: GetCurrencySpecificationResponse;
};

// group: Deposits

/**
 * Generate a fresh transaction ID for a deposit group.
 *
 * The resulting transaction ID can be specified when creating
 * a deposit group, so that the client can already start waiting for notifications
 * on that specific deposit group before the GreateDepositGroup request returns.
 */
export type GenerateDepositGroupTxIdOp = {
  op: WalletApiOperation.GenerateDepositGroupTxId;
  request: EmptyObject;
  response: TxIdResponse;
};

/**
 * Create a new deposit group.
 *
 * Deposit groups are used to deposit multiple coins to a bank
 * account, usually the wallet user's own bank account.
 */
export type CreateDepositGroupOp = {
  op: WalletApiOperation.CreateDepositGroup;
  request: CreateDepositGroupRequest;
  response: CreateDepositGroupResponse;
};

export type PrepareDepositOp = {
  op: WalletApiOperation.PrepareDeposit;
  request: PrepareDepositRequest;
  response: PrepareDepositResponse;
};

// group: Backups

/**
 * Export the recovery information for the wallet.
 */
export type ExportBackupRecoveryOp = {
  op: WalletApiOperation.ExportBackupRecovery;
  request: EmptyObject;
  response: BackupRecovery;
};

/**
 * Import recovery information into the wallet.
 */
export type ImportBackupRecoveryOp = {
  op: WalletApiOperation.ImportBackupRecovery;
  request: RecoveryLoadRequest;
  response: EmptyObject;
};

/**
 * Manually make and upload a backup.
 */
export type RunBackupCycleOp = {
  op: WalletApiOperation.RunBackupCycle;
  request: RunBackupCycleRequest;
  response: EmptyObject;
};

export type ExportBackupOp = {
  op: WalletApiOperation.ExportBackup;
  request: EmptyObject;
  response: EmptyObject;
};

/**
 * Add a new backup provider.
 */
export type AddBackupProviderOp = {
  op: WalletApiOperation.AddBackupProvider;
  request: AddBackupProviderRequest;
  response: AddBackupProviderResponse;
};

export type RemoveBackupProviderOp = {
  op: WalletApiOperation.RemoveBackupProvider;
  request: RemoveBackupProviderRequest;
  response: EmptyObject;
};

/**
 * Get some useful stats about the backup state.
 */
export type GetBackupInfoOp = {
  op: WalletApiOperation.GetBackupInfo;
  request: EmptyObject;
  response: BackupInfo;
};

/**
 * Set the internal device ID of the wallet, used to
 * identify whether a different/new wallet is accessing
 * the backup of another wallet.
 */
export type SetWalletDeviceIdOp = {
  op: WalletApiOperation.SetWalletDeviceId;
  request: SetWalletDeviceIdRequest;
  response: EmptyObject;
};

export type ListStoredBackupsOp = {
  op: WalletApiOperation.ListStoredBackups;
  request: EmptyObject;
  response: StoredBackupList;
};

export type CreateStoredBackupsOp = {
  op: WalletApiOperation.CreateStoredBackup;
  request: EmptyObject;
  response: CreateStoredBackupResponse;
};

export type RecoverStoredBackupsOp = {
  op: WalletApiOperation.RecoverStoredBackup;
  request: RecoverStoredBackupRequest;
  response: EmptyObject;
};

export type DeleteStoredBackupOp = {
  op: WalletApiOperation.DeleteStoredBackup;
  request: DeleteStoredBackupRequest;
  response: EmptyObject;
};

// group: Peer Payments

/**
 * Check if initiating a peer push payment is possible
 * based on the funds in the wallet.
 */
export type CheckPeerPushDebitOp = {
  op: WalletApiOperation.CheckPeerPushDebit;
  request: CheckPeerPushDebitRequest;
  response: CheckPeerPushDebitResponse;
};

/**
 * Initiate an outgoing peer push payment.
 */
export type InitiatePeerPushDebitOp = {
  op: WalletApiOperation.InitiatePeerPushDebit;
  request: InitiatePeerPushDebitRequest;
  response: InitiatePeerPushDebitResponse;
};

/**
 * Check an incoming peer push payment.
 */
export type PreparePeerPushCreditOp = {
  op: WalletApiOperation.PreparePeerPushCredit;
  request: PreparePeerPushCreditRequest;
  response: PreparePeerPushCreditResponse;
};

/**
 * Accept an incoming peer push payment.
 */
export type ConfirmPeerPushCreditOp = {
  op: WalletApiOperation.ConfirmPeerPushCredit;
  request: ConfirmPeerPushCreditRequest;
  response: EmptyObject;
};

/**
 * Check fees for an outgoing peer pull payment.
 */
export type CheckPeerPullCreditOp = {
  op: WalletApiOperation.CheckPeerPullCredit;
  request: CheckPeerPullCreditRequest;
  response: CheckPeerPullCreditResponse;
};

/**
 * Initiate an outgoing peer pull payment.
 */
export type InitiatePeerPullCreditOp = {
  op: WalletApiOperation.InitiatePeerPullCredit;
  request: InitiatePeerPullCreditRequest;
  response: InitiatePeerPullCreditResponse;
};

/**
 * Prepare for an incoming peer pull payment.
 */
export type PreparePeerPullDebitOp = {
  op: WalletApiOperation.PreparePeerPullDebit;
  request: PreparePeerPullDebitRequest;
  response: PreparePeerPullDebitResponse;
};

/**
 * Accept an incoming peer pull payment (i.e. pay the other party).
 */
export type ConfirmPeerPullDebitOp = {
  op: WalletApiOperation.ConfirmPeerPullDebit;
  request: ConfirmPeerPullDebitRequest;
  response: EmptyObject;
};

// group: Data Validation

export type ValidateIbanOp = {
  op: WalletApiOperation.ValidateIban;
  request: ValidateIbanRequest;
  response: ValidateIbanResponse;
};

// group: Database Management

/**
 * Export the wallet database's contents to JSON.
 */
export type ExportDbOp = {
  op: WalletApiOperation.ExportDb;
  request: EmptyObject;
  response: any;
};

export type ImportDbOp = {
  op: WalletApiOperation.ImportDb;
  request: ImportDbRequest;
  response: EmptyObject;
};

/**
 * Dangerously clear the whole wallet database.
 */
export type ClearDbOp = {
  op: WalletApiOperation.ClearDb;
  request: EmptyObject;
  response: EmptyObject;
};

/**
 * Export a backup, clear the database and re-import it.
 */
export type RecycleOp = {
  op: WalletApiOperation.Recycle;
  request: EmptyObject;
  response: EmptyObject;
};

// group: Testing and Debugging

/**
 * Apply a developer experiment to the current wallet state.
 *
 * This allows UI developers / testers to play around without
 * an elaborate test environment.
 */
export type ApplyDevExperimentOp = {
  op: WalletApiOperation.ApplyDevExperiment;
  request: ApplyDevExperimentRequest;
  response: EmptyObject;
};

/**
 * Run a simple integration test on a test deployment
 * of the exchange and merchant.
 */
export type RunIntegrationTestOp = {
  op: WalletApiOperation.RunIntegrationTest;
  request: IntegrationTestArgs;
  response: EmptyObject;
};

/**
 * Run a simple integration test on a test deployment
 * of the exchange and merchant.
 */
export type RunIntegrationTestV2Op = {
  op: WalletApiOperation.RunIntegrationTestV2;
  request: IntegrationTestArgs;
  response: EmptyObject;
};

/**
 * Test crypto worker.
 */
export type TestCryptoOp = {
  op: WalletApiOperation.TestCrypto;
  request: EmptyObject;
  response: any;
};

/**
 * Make withdrawal on a test deployment of the exchange
 * and merchant.
 */
export type WithdrawTestBalanceOp = {
  op: WalletApiOperation.WithdrawTestBalance;
  request: WithdrawTestBalanceRequest;
  response: EmptyObject;
};

/**
 * Make a withdrawal of testkudos on test.taler.net.
 */
export type WithdrawTestkudosOp = {
  op: WalletApiOperation.WithdrawTestkudos;
  request: EmptyObject;
  response: EmptyObject;
};

/**
 * Make a test payment using a test deployment of
 * the exchange and merchant.
 */
export type TestPayOp = {
  op: WalletApiOperation.TestPay;
  request: TestPayArgs;
  response: TestPayResult;
};

/**
 * Get wallet-internal pending tasks.
 */
export type GetUserAttentionRequests = {
  op: WalletApiOperation.GetUserAttentionRequests;
  request: UserAttentionsRequest;
  response: UserAttentionsResponse;
};

/**
 * Get wallet-internal pending tasks.
 */
export type MarkAttentionRequestAsRead = {
  op: WalletApiOperation.MarkAttentionRequestAsRead;
  request: UserAttentionByIdRequest;
  response: EmptyObject;
};

/**
 * Get wallet-internal pending tasks.
 */
export type GetUserAttentionsUnreadCount = {
  op: WalletApiOperation.GetUserAttentionUnreadCount;
  request: UserAttentionsRequest;
  response: UserAttentionsCountResponse;
};

/**
 * Get wallet-internal pending tasks.
 *
 * @deprecated
 */
export type GetPendingTasksOp = {
  op: WalletApiOperation.GetPendingOperations;
  request: EmptyObject;
  response: any;
};

export type GetActiveTasksOp = {
  op: WalletApiOperation.GetActiveTasks;
  request: EmptyObject;
  response: GetActiveTasks;
};

/**
 * Dump all coins of the wallet in a simple JSON format.
 */
export type DumpCoinsOp = {
  op: WalletApiOperation.DumpCoins;
  request: EmptyObject;
  response: CoinDumpJson;
};

/**
 * Add an offset to the wallet's internal time.
 */
export type TestingSetTimetravelOp = {
  op: WalletApiOperation.TestingSetTimetravel;
  request: TestingSetTimetravelRequest;
  response: EmptyObject;
};

/**
 * Add an offset to the wallet's internal time.
 */
export type TestingListTasksForTransactionOp = {
  op: WalletApiOperation.TestingListTaskForTransaction;
  request: TestingListTasksForTransactionRequest;
  response: TestingListTasksForTransactionsResponse;
};

/**
 * Wait until all transactions are in a final state.
 */
export type TestingWaitTransactionsFinalOp = {
  op: WalletApiOperation.TestingWaitTransactionsFinal;
  request: EmptyObject;
  response: EmptyObject;
};

/**
 * Wait until all refresh transactions are in a final state.
 */
export type TestingWaitRefreshesFinalOp = {
  op: WalletApiOperation.TestingWaitRefreshesFinal;
  request: EmptyObject;
  response: EmptyObject;
};

/**
 * Wait until a transaction is in a particular state.
 */
export type TestingWaitTransactionStateOp = {
  op: WalletApiOperation.TestingWaitTransactionState;
  request: TestingWaitTransactionRequest;
  response: EmptyObject;
};

/**
 * Get stats about an exchange denomination.
 */
export type TestingGetDenomStatsOp = {
  op: WalletApiOperation.TestingGetDenomStats;
  request: TestingGetDenomStatsRequest;
  response: TestingGetDenomStatsResponse;
};

/**
 * Set a coin as (un-)suspended.
 * Suspended coins won't be used for payments.
 */
export type SetCoinSuspendedOp = {
  op: WalletApiOperation.SetCoinSuspended;
  request: SetCoinSuspendedRequest;
  response: EmptyObject;
};

/**
 * Force a refresh on coins where it would not
 * be necessary.
 */
export type ForceRefreshOp = {
  op: WalletApiOperation.ForceRefresh;
  request: ForceRefreshRequest;
  response: EmptyObject;
};

export type WalletOperations = {
  [WalletApiOperation.InitWallet]: InitWalletOp;
  [WalletApiOperation.GetVersion]: GetVersionOp;
  [WalletApiOperation.PreparePayForUri]: PreparePayForUriOp;
  [WalletApiOperation.SharePayment]: SharePaymentOp;
  [WalletApiOperation.PreparePayForTemplate]: PreparePayForTemplateOp;
  [WalletApiOperation.GetContractTermsDetails]: GetContractTermsDetailsOp;
  [WalletApiOperation.WithdrawTestkudos]: WithdrawTestkudosOp;
  [WalletApiOperation.ConfirmPay]: ConfirmPayOp;
  [WalletApiOperation.AbortTransaction]: AbortTransactionOp;
  [WalletApiOperation.FailTransaction]: FailTransactionOp;
  [WalletApiOperation.SuspendTransaction]: SuspendTransactionOp;
  [WalletApiOperation.ResumeTransaction]: ResumeTransactionOp;
  [WalletApiOperation.GetBalances]: GetBalancesOp;
  [WalletApiOperation.ConvertDepositAmount]: ConvertDepositAmountOp;
  [WalletApiOperation.GetMaxDepositAmount]: GetMaxDepositAmountOp;
  [WalletApiOperation.ConvertPeerPushAmount]: ConvertPeerPushAmountOp;
  [WalletApiOperation.GetMaxPeerPushAmount]: GetMaxPeerPushAmountOp;
  [WalletApiOperation.ConvertWithdrawalAmount]: ConvertWithdrawalAmountOp;
  [WalletApiOperation.GetPlanForOperation]: GetPlanForOperationOp;
  [WalletApiOperation.GetBalanceDetail]: GetBalancesDetailOp;
  [WalletApiOperation.GetTransactions]: GetTransactionsOp;
  [WalletApiOperation.TestingGetSampleTransactions]: TestingGetSampleTransactionsOp;
  [WalletApiOperation.GetTransactionById]: GetTransactionByIdOp;
  [WalletApiOperation.GetWithdrawalTransactionByUri]: GetWithdrawalTransactionByUriOp;
  [WalletApiOperation.RetryPendingNow]: RetryPendingNowOp;
  [WalletApiOperation.GetPendingOperations]: GetPendingTasksOp;
  [WalletApiOperation.GetActiveTasks]: GetActiveTasksOp;
  [WalletApiOperation.GetUserAttentionRequests]: GetUserAttentionRequests;
  [WalletApiOperation.GetUserAttentionUnreadCount]: GetUserAttentionsUnreadCount;
  [WalletApiOperation.MarkAttentionRequestAsRead]: MarkAttentionRequestAsRead;
  [WalletApiOperation.DumpCoins]: DumpCoinsOp;
  [WalletApiOperation.SetCoinSuspended]: SetCoinSuspendedOp;
  [WalletApiOperation.ForceRefresh]: ForceRefreshOp;
  [WalletApiOperation.DeleteTransaction]: DeleteTransactionOp;
  [WalletApiOperation.RetryTransaction]: RetryTransactionOp;
  [WalletApiOperation.StartRefundQueryForUri]: StartRefundQueryForUriOp;
  [WalletApiOperation.StartRefundQuery]: StartRefundQueryOp;
  [WalletApiOperation.GetWithdrawalDetailsForAmount]: GetWithdrawalDetailsForAmountOp;
  [WalletApiOperation.GetWithdrawalDetailsForUri]: GetWithdrawalDetailsForUriOp;
  [WalletApiOperation.AcceptBankIntegratedWithdrawal]: AcceptBankIntegratedWithdrawalOp;
  [WalletApiOperation.AcceptManualWithdrawal]: AcceptManualWithdrawalOp;
  [WalletApiOperation.ListExchanges]: ListExchangesOp;
  [WalletApiOperation.ListExchangesForScopedCurrency]: ListExchangesForScopedCurrencyOp;
  [WalletApiOperation.AddExchange]: AddExchangeOp;
  [WalletApiOperation.ListKnownBankAccounts]: ListKnownBankAccountsOp;
  [WalletApiOperation.AddKnownBankAccounts]: AddKnownBankAccountsOp;
  [WalletApiOperation.ForgetKnownBankAccounts]: ForgetKnownBankAccountsOp;
  [WalletApiOperation.SetExchangeTosAccepted]: SetExchangeTosAcceptedOp;
  [WalletApiOperation.SetExchangeTosForgotten]: SetExchangeTosForgottenOp;
  [WalletApiOperation.GetExchangeTos]: GetExchangeTosOp;
  [WalletApiOperation.GetExchangeDetailedInfo]: GetExchangeDetailedInfoOp;
  [WalletApiOperation.GetExchangeEntryByUrl]: GetExchangeEntryByUrlOp;
  [WalletApiOperation.PrepareDeposit]: PrepareDepositOp;
  [WalletApiOperation.GenerateDepositGroupTxId]: GenerateDepositGroupTxIdOp;
  [WalletApiOperation.CreateDepositGroup]: CreateDepositGroupOp;
  [WalletApiOperation.SetWalletDeviceId]: SetWalletDeviceIdOp;
  [WalletApiOperation.ExportBackupRecovery]: ExportBackupRecoveryOp;
  [WalletApiOperation.ImportBackupRecovery]: ImportBackupRecoveryOp;
  [WalletApiOperation.RunBackupCycle]: RunBackupCycleOp;
  [WalletApiOperation.ExportBackup]: ExportBackupOp;
  [WalletApiOperation.AddBackupProvider]: AddBackupProviderOp;
  [WalletApiOperation.RemoveBackupProvider]: RemoveBackupProviderOp;
  [WalletApiOperation.GetBackupInfo]: GetBackupInfoOp;
  [WalletApiOperation.RunIntegrationTest]: RunIntegrationTestOp;
  [WalletApiOperation.RunIntegrationTestV2]: RunIntegrationTestV2Op;
  [WalletApiOperation.TestCrypto]: TestCryptoOp;
  [WalletApiOperation.WithdrawTestBalance]: WithdrawTestBalanceOp;
  [WalletApiOperation.TestPay]: TestPayOp;
  [WalletApiOperation.ExportDb]: ExportDbOp;
  [WalletApiOperation.ImportDb]: ImportDbOp;
  [WalletApiOperation.CheckPeerPushDebit]: CheckPeerPushDebitOp;
  [WalletApiOperation.InitiatePeerPushDebit]: InitiatePeerPushDebitOp;
  [WalletApiOperation.PreparePeerPushCredit]: PreparePeerPushCreditOp;
  [WalletApiOperation.ConfirmPeerPushCredit]: ConfirmPeerPushCreditOp;
  [WalletApiOperation.CheckPeerPullCredit]: CheckPeerPullCreditOp;
  [WalletApiOperation.InitiatePeerPullCredit]: InitiatePeerPullCreditOp;
  [WalletApiOperation.PreparePeerPullDebit]: PreparePeerPullDebitOp;
  [WalletApiOperation.ConfirmPeerPullDebit]: ConfirmPeerPullDebitOp;
  [WalletApiOperation.ClearDb]: ClearDbOp;
  [WalletApiOperation.Recycle]: RecycleOp;
  [WalletApiOperation.ApplyDevExperiment]: ApplyDevExperimentOp;
  [WalletApiOperation.ValidateIban]: ValidateIbanOp;
  [WalletApiOperation.TestingWaitTransactionsFinal]: TestingWaitTransactionsFinalOp;
  [WalletApiOperation.TestingWaitRefreshesFinal]: TestingWaitRefreshesFinalOp;
  [WalletApiOperation.TestingSetTimetravel]: TestingSetTimetravelOp;
  [WalletApiOperation.TestingWaitTransactionState]: TestingWaitTransactionStateOp;
  [WalletApiOperation.GetCurrencySpecification]: GetCurrencySpecificationOp;
  [WalletApiOperation.CreateStoredBackup]: CreateStoredBackupsOp;
  [WalletApiOperation.ListStoredBackups]: ListStoredBackupsOp;
  [WalletApiOperation.DeleteStoredBackup]: DeleteStoredBackupOp;
  [WalletApiOperation.RecoverStoredBackup]: RecoverStoredBackupsOp;
  [WalletApiOperation.UpdateExchangeEntry]: UpdateExchangeEntryOp;
  [WalletApiOperation.PrepareWithdrawExchange]: PrepareWithdrawExchangeOp;
  [WalletApiOperation.TestingInfiniteTransactionLoop]: any;
  [WalletApiOperation.DeleteExchange]: DeleteExchangeOp;
  [WalletApiOperation.GetExchangeResources]: GetExchangeResourcesOp;
  [WalletApiOperation.ListGlobalCurrencyAuditors]: ListGlobalCurrencyAuditorsOp;
  [WalletApiOperation.ListGlobalCurrencyExchanges]: ListGlobalCurrencyExchangesOp;
  [WalletApiOperation.AddGlobalCurrencyAuditor]: AddGlobalCurrencyAuditorOp;
  [WalletApiOperation.RemoveGlobalCurrencyAuditor]: RemoveGlobalCurrencyAuditorOp;
  [WalletApiOperation.AddGlobalCurrencyExchange]: AddGlobalCurrencyExchangeOp;
  [WalletApiOperation.RemoveGlobalCurrencyExchange]: RemoveGlobalCurrencyExchangeOp;
  [WalletApiOperation.ListAssociatedRefreshes]: ListAssociatedRefreshesOp;
  [WalletApiOperation.TestingListTaskForTransaction]: TestingListTasksForTransactionOp;
  [WalletApiOperation.TestingGetDenomStats]: TestingGetDenomStatsOp;
};

export type WalletCoreRequestType<
  Op extends WalletApiOperation & keyof WalletOperations,
> = WalletOperations[Op] extends { request: infer T } ? T : never;

export type WalletCoreResponseType<
  Op extends WalletApiOperation & keyof WalletOperations,
> = WalletOperations[Op] extends { response: infer T } ? T : never;

export type WalletCoreOpKeys = WalletApiOperation & keyof WalletOperations;

export interface WalletCoreApiClient {
  call<Op extends keyof WalletOperations>(
    operation: Op,
    payload: WalletCoreRequestType<Op>,
  ): Promise<WalletCoreResponseType<Op>>;
}
