/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import { createWalletDaemonWithClient } from "../harness/helpers.js";

export async function runWalletConfigTest(t: GlobalTestState) {
  const w1 = await createWalletDaemonWithClient(t, {
    name: "w1",
    config: {
      builtin: {
        exchanges: [],
      },
    },
  });

  const exchangesResp1 = await w1.walletClient.call(
    WalletApiOperation.ListExchanges,
    {},
  );

  t.assertDeepEqual(exchangesResp1.exchanges.length, 0);

  const w2 = await createWalletDaemonWithClient(t, {
    name: "w2",
    config: {
      builtin: {
        exchanges: [
          {
            exchangeBaseUrl: "https://exchange.demo.taler.net/",
          },
          {
            exchangeBaseUrl: "https://exchange.test.taler.net/",
          },
        ],
      },
    },
  });

  const exchangesResp2 = await w2.walletClient.call(
    WalletApiOperation.ListExchanges,
    {},
  );

  t.assertDeepEqual(exchangesResp2.exchanges.length, 2);
}

runWalletConfigTest.suites = ["wallet"];
