/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV2,
  withdrawViaBankV2,
  makeTestPaymentV2,
} from "../harness/helpers.js";
import { j2s } from "@gnu-taler/taler-util";

/**
 * Run test for basic, bank-integrated withdrawal and payment.
 */
export async function runPaymentTest(t: GlobalTestState) {
  // Set up test environment

  const { walletClient, bank, exchange, merchant } =
    await createSimpleTestkudosEnvironmentV2(t);

  // Withdraw digital cash into the wallet.

  await withdrawViaBankV2(t, { walletClient, bank, exchange, amount: "TESTKUDOS:20" });

  await walletClient.call(WalletApiOperation.TestingWaitTransactionsFinal, {});

  const order = {
    summary: "Buy me!",
    amount: "TESTKUDOS:5",
    fulfillment_url: "taler://fulfillment-success/thx",
  };

  await makeTestPaymentV2(t, { walletClient, merchant, order });
  await walletClient.call(WalletApiOperation.TestingWaitTransactionsFinal, {});

  // Test JSON normalization of contract terms: Does the wallet
  // agree with the merchant?
  const order2 = {
    summary: "Testing “unicode” characters: 😁😱😇🥺🫦",
    amount: "TESTKUDOS:5",
    fulfillment_url: "taler://fulfillment-success/thx",
  };

  await makeTestPaymentV2(t, { walletClient, merchant, order: order2 });
  await walletClient.call(WalletApiOperation.TestingWaitTransactionsFinal, {});

  // Test JSON normalization of contract terms: Does the wallet
  // agree with the merchant?
  const order3 = {
    summary: "Testing\nNewlines\rAnd\tStuff\nHere\b",
    amount: "TESTKUDOS:5",
    fulfillment_url: "taler://fulfillment-success/thx",
  };

  await makeTestPaymentV2(t, { walletClient, merchant, order: order3 });
  await walletClient.call(WalletApiOperation.TestingWaitTransactionsFinal, {});

  const bal = await walletClient.call(WalletApiOperation.GetBalances, {});
  console.log(`balance after 3 payments: ${j2s(bal)}`);
  t.assertAmountEquals(bal.balances[0].available, "TESTKUDOS:3.8");
  t.assertAmountEquals(bal.balances[0].pendingIncoming, "TESTKUDOS:0");
  t.assertAmountEquals(bal.balances[0].pendingOutgoing, "TESTKUDOS:0");
}

runPaymentTest.suites = ["wallet"];
