/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV2,
  withdrawViaBankV2,
} from "../harness/helpers.js";

/**
 * Run test for refreshe after a payment.
 */
export async function runDenomLostTest(t: GlobalTestState) {
  // Set up test environment

  const { walletClient, bank, exchange, merchant } =
    await createSimpleTestkudosEnvironmentV2(t);

  // Withdraw digital cash into the wallet.

  const wres = await withdrawViaBankV2(t, {
    walletClient,
    bank,
    exchange,
    amount: "TESTKUDOS:20",
  });

  await wres.withdrawalFinishedCond;

  const dsBefore = await walletClient.call(
    WalletApiOperation.TestingGetDenomStats,
    {
      exchangeBaseUrl: exchange.baseUrl,
    },
  );

  t.assertDeepEqual(dsBefore.numLost, 0);
  t.assertDeepEqual(dsBefore.numOffered, dsBefore.numKnown);

  await exchange.stop();

  await exchange.purgeSecmodKeys();

  await exchange.start();

  await walletClient.call(WalletApiOperation.UpdateExchangeEntry, {
    exchangeBaseUrl: exchange.baseUrl,
    force: true,
  });

  const dsAfter = await walletClient.call(
    WalletApiOperation.TestingGetDenomStats,
    {
      exchangeBaseUrl: exchange.baseUrl,
    },
  );

  // All previous denominations were lost
  t.assertDeepEqual(dsBefore.numOffered, dsAfter.numLost);
  // But we have new ones!
  t.assertTrue(dsAfter.numKnown > dsBefore.numKnown);
}

runDenomLostTest.suites = ["wallet"];
