import { AmlExchangeBackend } from "./types.js";

export const amlStateConverter = {
  toStringUI: stringifyAmlState,
  fromStringUI: parseAmlState,
};

function stringifyAmlState(s: AmlExchangeBackend.AmlState | undefined): string {
  if (s === undefined) return "";
  switch (s) {
    case AmlExchangeBackend.AmlState.normal:
      return "normal";
    case AmlExchangeBackend.AmlState.pending:
      return "pending";
    case AmlExchangeBackend.AmlState.frozen:
      return "frozen";
  }
}

function parseAmlState(s: string | undefined): AmlExchangeBackend.AmlState {
  switch (s) {
    case "normal":
      return AmlExchangeBackend.AmlState.normal;
    case "pending":
      return AmlExchangeBackend.AmlState.pending;
    case "frozen":
      return AmlExchangeBackend.AmlState.frozen;
    default:
      throw Error(`unknown AML state: ${s}`);
  }
}
