import { Fragment, h } from "preact";
import { useOfficer } from "../hooks/useOfficer.js";
import { HandleAccountNotReady } from "./HandleAccountNotReady.js";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { uiSettings } from "../settings.js";
import { getInitialBackendBaseURL } from "../hooks/useBackend.js";

export function Officer() {
  const officer = useOfficer();
  const { i18n } = useTranslationContext()
  if (officer.state !== "ready") {
    return <HandleAccountNotReady officer={officer} />;
  }

  const url = new URL(getInitialBackendBaseURL())
  const signupEmail = uiSettings.signupEmail ?? `aml-signup@${url.hostname}`

  return (
    <div>
      <h1 class="my-2 text-3xl font-bold tracking-tight text-gray-900 ">
        <i18n.Translate>Public key</i18n.Translate>
      </h1>
      <div class="max-w-xl text-base leading-7 text-gray-700 lg:max-w-lg">
        <p class="mt-6 font-mono break-all">{officer.account.id}</p>
      </div>
      <p>
        <a
          href={`mailto:${signupEmail}?subject=${encodeURIComponent("Request AML signup")}&body=${encodeURIComponent(`I want my AML account\n\n\nPubKey: ${officer.account.id}`)}`}
          target="_blank"
          rel="noreferrer"
          class="m-4 block rounded-md w-fit border-0 px-3 py-2 text-center text-sm bg-indigo-700 text-white shadow-sm hover:bg-indigo-700"
        >
          <i18n.Translate>Request account activation</i18n.Translate>
        </a>
      </p>
      <p>
        <button
          type="button"
          onClick={() => {
            officer.lock();
          }}
          class="m-4 block rounded-md border-0 bg-gray-200 px-3 py-2 text-center text-sm text-black shadow-sm "
        >
          <i18n.Translate>Lock account</i18n.Translate>
        </button>
      </p>
      <p>
        <button
          type="button"
          onClick={() => {
            officer.forget();
          }}
          class="m-4 block rounded-md bg-red-600 px-3 py-2 text-center text-sm  text-white shadow-sm hover:bg-red-500 "
        >
          <i18n.Translate>Forget account</i18n.Translate>
        </button>
      </p>
    </div>
  );
}
