import { VNode, h } from "preact";
import { OfficerNotReady } from "../hooks/useOfficer.js";
import { CreateAccount } from "./CreateAccount.js";
import { UnlockAccount } from "./UnlockAccount.js";
import { assertUnreachable } from "@gnu-taler/taler-util";

export function HandleAccountNotReady({
  officer,
}: {
  officer: OfficerNotReady;
}): VNode {
  if (officer.state === "not-found") {
    return (
      <CreateAccount
        onNewAccount={(password) => {
          officer.create(password);
        }}
      />
    );
  }

  if (officer.state === "locked") {
    return (
      <UnlockAccount
        onRemoveAccount={() => {
          officer.forget();
        }}
        onAccountUnlocked={async (pwd) => {
          await officer.tryUnlock(pwd);
        }}
      />
    );
  }
  assertUnreachable(officer)
}
