/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import * as tests from "@gnu-taler/web-util/testing";
import {
  AntiMoneyLaunderingForm as TestedComponent,
} from "./AntiMoneyLaunderingForm.js";

export default {
  title: "aml form",
};

export const SimpleComment = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "simple_comment",
  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});

export const Identification = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.1e",
  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});

export const OperationalLegalEntity = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.11e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});
export const Foundations = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.12e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});
export const DelcarationOfTrusts = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.13e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});

export const InformationOnLifeInsurance = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.15e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});
export const DeclarationOfBeneficialOwner = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.9e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});
export const CustomerProfile = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.5e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});
export const RiskProfile = tests.createExample(TestedComponent, {
  account: "the_account",
  formId: "902.4e",

  onSubmit: async (justification, newState, newThreshold) => {
    alert(JSON.stringify({ justification, newState, newThreshold }, undefined, 2))
  }
});

