import { useState } from "preact/hooks";

// FIX default import https://github.com/microsoft/TypeScript/issues/49189
import { AmountString, HttpStatusCode, OfficerAccount, OperationFail, TalerExchangeApi, TalerExchangeResultByMethod, TalerHttpError } from "@gnu-taler/taler-util";
import _useSWR, { SWRHook } from "swr";
import { useExchangeApiContext } from "../context/config.js";
import { useOfficer } from "./useOfficer.js";
import { AmlExchangeBackend } from "../utils/types.js";
const useSWR = _useSWR as unknown as SWRHook;

const PAGE_SIZE = 10;
/**
 * FIXME: mutate result when balance change (transaction )
 * @param account
 * @param args
 * @returns
 */
export function useCases(state: AmlExchangeBackend.AmlState) {
  const officer = useOfficer();
  const session = officer.state === "ready" ? officer.account : undefined;
  const { api } = useExchangeApiContext();

  const [offset, setOffset] = useState<string>();

  async function fetcher([officer, state, offset]: [OfficerAccount, AmlExchangeBackend.AmlState, string | undefined]) {
    return await api.getDecisionsByState(officer, state, {
      order: "asc", offset, limit: PAGE_SIZE + 1
    })
  }

  const { data, error } = useSWR<TalerExchangeResultByMethod<"getDecisionsByState">, TalerHttpError>(
    !session ? undefined : [session, state, offset],
    fetcher,
  );

  // const [lastAfter, setLastAfter] = useState<
  //   HttpResponse<AmlExchangeBackend.AmlRecords, AmlExchangeBackend.AmlError>
  // >({ loading: true });

  // useEffect(() => {
  //   if (afterData) setLastAfter(afterData);
  // }, [afterData]);

  // if (afterError) {
  //   return afterError.cause;
  // }

  // if the query returns less that we ask, then we have reach the end or beginning
  const isLastPage =
    data && data.type === "ok" && data.body.records.length <= PAGE_SIZE;
  const isFirstPage = !offset;

  const pagination = {
    isLastPage,
    isFirstPage,
    loadMore: () => {
      if (isLastPage || data?.type !== "ok") return;
      const list = data.body.records
      setOffset(String(list[list.length - 1].rowid));
    },
    reset: () => {
      setOffset(undefined)
    },
  };

  // const public_accountslist = data?.type !== "ok" ? [] : data.body.public_accounts;
  if (!session) {
    return {
      data: {
        type: "fail",
        case: HttpStatusCode.Unauthorized,
        detail: {}
      } as OperationFail<never>
    }
  }

  if (data) {
    if (data.type === "fail") {
      return { data }
    }
    const records = isLastPage ? data.body.records : removeLastElement(data.body.records)
    return { data: { type: "ok" as const, body: { records } }, pagination }
  }
  if (error) {
    return error;
  }
  return undefined;
}

function removeLastElement<T>(list: Array<T>): Array<T> {
  if (list.length === 0) {
    return list;
  }
  return list.slice(0, -1)
}