
// FIX default import https://github.com/microsoft/TypeScript/issues/49189
import { AmountString, OfficerAccount, PaytoString, TalerExchangeApi, TalerExchangeResultByMethod, TalerHttpError } from "@gnu-taler/taler-util";
import _useSWR, { SWRHook } from "swr";
import { useExchangeApiContext } from "../context/config.js";
import { useOfficer } from "./useOfficer.js";
const useSWR = _useSWR as unknown as SWRHook;

export function useCaseDetails(paytoHash: string) {
  const officer = useOfficer();
  const session = officer.state === "ready" ? officer.account : undefined;

  const { api } = useExchangeApiContext();

  async function fetcher([officer, account]: [OfficerAccount, PaytoString]) {
    return await api.getDecisionDetails(officer, account)
  }

  const { data, error } = useSWR<TalerExchangeResultByMethod<"getDecisionDetails">, TalerHttpError>(
    !session ? undefined : [session, paytoHash], fetcher, {
    refreshInterval: 0,
    refreshWhenHidden: false,
    revalidateOnFocus: false,
    revalidateOnReconnect: false,
    refreshWhenOffline: false,
    errorRetryCount: 0,
    errorRetryInterval: 1,
    shouldRetryOnError: false,
    keepPreviousData: true,
  });

  if (data) return data;
  if (error) return error;
  return undefined;
}

const example1: TalerExchangeApi.AmlDecisionDetails = {
  aml_history: [
    {
      justification: "Lack of documentation",
      decider_pub: "ASDASDASD",
      decision_time: {
        t_s: Date.now() / 1000,
      },
      new_state: 2,
      new_threshold: "USD:0" as AmountString,
    },
    {
      justification: "Doing a transfer of high amount",
      decider_pub: "ASDASDASD",
      decision_time: {
        t_s: Date.now() / 1000 - 60 * 60 * 24 * 30 * 6,
      },
      new_state: 1,
      new_threshold: "USD:2000" as AmountString,
    },
    {
      justification: "Account is known to the system",
      decider_pub: "ASDASDASD",
      decision_time: {
        t_s: Date.now() / 1000 - 60 * 60 * 24 * 30 * 9,
      },
      new_state: 0,
      new_threshold: "USD:100" as AmountString,
    },
  ],
  kyc_attributes: [
    {
      collection_time: {
        t_s: Date.now() / 1000 - 60 * 60 * 24 * 30 * 8,
      },
      expiration_time: {
        t_s: Date.now() / 1000 - 60 * 60 * 24 * 30 * 4,
      },
      provider_section: "asdasd",
      attributes: {
        name: "Sebastian",
      },
    },
    {
      collection_time: {
        t_s: Date.now() / 1000 - 60 * 60 * 24 * 30 * 5,
      },
      expiration_time: {
        t_s: Date.now() / 1000 - 60 * 60 * 24 * 30 * 2,
      },
      provider_section: "asdasd",
      attributes: {
        creditCard: "12312312312",
      },
    },
  ],
};


