import { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import { FlexibleForm, FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { resolutionSection } from "./simplest.js";
import { BaseForm } from "./declaration.js";

export const v1 = (i18n: InternationalizationAPI) => (current: BaseForm): FlexibleForm<Form902_9.Form> => ({
  design: [
    {
      title:
        i18n.str`Declaration of identity of the beneficial owner`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`,
          },
        },
        {
          type: "caption",
          props: {
            label:
              i18n.str`The contracting partner hereby declares that the person(s) listed below is/are the beneficial owner(s) of the assets involved in the business relationship. If the contracting partner is also the sole beneficial owner of the assets, the contracting partner's detail must be set out below`,
          },
        },
        {
          type: "array",
          props: {
            label: i18n.str`Persons`,
            labelField: "surname",
            name: "persons",
            fields: [
              {
                type: "text",
                props: {
                  name: "surname",
                  label: i18n.str`Surname(s)`,
                },
              },
              {
                type: "text",
                props: {
                  name: "firstName",
                  label: i18n.str`First name(s)`,
                },
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile`,
                },
              },
            ],
          },
        },
        {
          type: "caption",
          props: {
            label:
              i18n.str`The contracting partner hereby undertakes to inform automatically of any changes to the information contained herein`,
          },
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: i18n.str`Signature`,
          },
        },
        {
          type: "caption",
          props: {
            label:
              i18n.str`It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)`,
          },
        },
      ],
    },
    resolutionSection(current, i18n),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_9.Form>,
  ): FormState<Form902_9.Form> {
    return {
    };
  },
});

namespace Form902_9 {
  interface Person {
    surname: string;
    firstName: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
    address: string;
  }
  export interface Form extends BaseForm {
    contractingPartner: string;
    persons: Person;
    signature: string;
  }
}
