import type { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import type { FlexibleForm, FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { h as create } from "preact";
import { resolutionSection } from "./simplest.js";
import { BaseForm } from "./declaration.js";
import { ArrowRightIcon, ChevronRightIcon } from "./icons.js";

export const v1 = (i18n: InternationalizationAPI) => (current: BaseForm): FlexibleForm<Form902_4.Form> => ({
  design: [
    {
      title: i18n.str`Risk Profile AMLA`,
      description:
        i18n.str`Evaluation of business relationship with increased risk and definition of criteria for transaction monitoring.`,
      fields: [
        {
          type: "caption",
          props: {
            label:
              i18n.str`The member performs additional clarifications if the business relationship or the transaction is classified as increased risk (Art. 56 SRO Regulations)`,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "text",
          props: {
            name: "customer",
            label: i18n.str`Customer`,
            help: i18n.str`Pursuant identification form (VQF doc. Nr. 902.1) numeral 1`,
          },
        },
      ],
    },
    {
      title:
        i18n.str`Evaluation of politically exposed persons (PEP-Check)`,
      fields: [
        {
          type: "caption",
          props: {
            label:
              i18n.str`This evaluation has to be completed by all members for every business relationship`,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Foreign PEP`,
            // tooltip:
            //   i18n.str`Definition see Art. 7 lit. g numeral 1 SRO Regulations`,
            help: i18n.str`Is the customer, the beneficial owner or the controlling person or authorized representative a foreign PEP or closely related to such a person?`,
            name: "pep.foreign",
            choices: [
              {
                label: i18n.str`No`,
                value: "no",
              },
              {
                label: i18n.str`Yes`,
                description:
                  i18n.str`The business relationship is compulsory  classified as increased risk`,
                value: "yes",
              },
            ],
          },
        },
        {
          type: "choiceStacked",
          props: {
            label:
              i18n.str`Domestic PEP and PEP of International Organizations`,
            // tooltip:
            //   i18n.str`Definition see Art. 7 lit. g numeral 2 and 3 SRO Regulations `,
            help: i18n.str`Is the customer, the beneficial owner or the controlling person or authorized representative a domestic PEP or PEP in International Organizations or closely related to such a person?`,
            name: "pep.domestic",
            choices: [
              {
                label: i18n.str`No`,
                value: "no",
              },
              {
                label:
                  i18n.str`Yes, but NOT risk criterion pursuant to numeral 3 subsequently increased.`,
                value: "yes-but-no-risk",
              },
              {
                label:
                  i18n.str`Yes, AND a risk criterion pursuant to numeral 3 subsequently increased.`,
                description:
                  i18n.str`Classification of the business relationship as increased risk is compulsory`,
                value: "yes",
              },
            ],
          },
        },
        {
          type: "absoluteTime",
          props: {
            label:
              i18n.str`The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on`,
            name: "pep.when",
            pattern: "dd/MM/yyyy",
            // placeholder: i18n.str`dd/MM/yyyy`,
          },
        },
      ],
    },
    {
      title:
        'Evaluation "high risk" or non-cooperative country' as TranslatedString,
      fields: [
        {
          type: "caption",
          props: {
            label:
              i18n.str`This evaluation has to be completed by all members for every business relationship`,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: '"High risk" or non-cooperative country' as TranslatedString,
            help: 'Is the customer, the beneficial owner or the controlling person or authorized representative in a country considered by the FATF "high risk" or non-cooperative and for which FATF requires increased diligence?' as TranslatedString,
            name: "highRisk.evaluation",
            choices: [
              {
                label: i18n.str`No`,
                value: "no",
              },
              {
                label: i18n.str`Yes`,
                description:
                  i18n.str`considered as business relationship with increased risk`,
                value: "yes",
              },
            ],
          },
        },
        {
          type: "absoluteTime",
          props: {
            label:
              i18n.str`The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on`,
            name: "highRisk.when",
            pattern: "dd/MM/yyyy",
            // placeholder: i18n.str`dd/MM/yyyy`,
          },
        },
      ],
    },
    {
      title: i18n.str`Evaluation of business relationship risk`,
      fields: [
        {
          type: "caption",
          props: {
            label:
              i18n.str`This evaluation has to be completed by all members who have in total more than 20 customers for every business relationship. At least two risk categories have to be chosen and assessed`,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`a) Country risk (nationality)`,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Domicile/residential address`,
                  name: "evaluation.nationality.address",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer",
                    },
                    {
                      label:
                        i18n.str`Beneficial owner of the assets`,
                      value: "owner",
                    },
                    {
                      label: i18n.str`Controlling person`,
                      value: "controlling",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Nationality`,
                  name: "evaluation.nationality.nationality",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer",
                    },
                    {
                      label:
                        i18n.str`Beneficial owner of the assets`,
                      value: "owner",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.nationality.risk",
                  choices: [
                    {
                      label:
                        i18n.str`Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "low",
                    },
                    {
                      label:
                        i18n.str`Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "medium",
                    },
                    {
                      label:
                        i18n.str`Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`b) Country risk (business activity)`,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Place of business activity`,
                  name: "evaluation.business.place",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer",
                    },
                    {
                      label:
                        i18n.str`Beneficial owner of the assets`,
                      value: "owner",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.business.risk",
                  choices: [
                    {
                      label:
                        i18n.str`Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "low",
                    },
                    {
                      label:
                        i18n.str`Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "medium",
                    },
                    {
                      label:
                        i18n.str`Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`c) Country risk (payments)`,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    i18n.str`Country of origin and destination of frequent payments (if known)`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.payments.risk",
                  choices: [
                    {
                      label:
                        i18n.str`Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "low",
                    },
                    {
                      label:
                        i18n.str`Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "medium",
                    },
                    {
                      label:
                        i18n.str`Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`d) Industry risk`,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label:
                    i18n.str`Nature of customer's business activity`,
                  name: "evaluation.industry.nature",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer",
                    },
                    {
                      label:
                        i18n.str`Beneficial owner of the assets`,
                      value: "owner",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.payments.risk",
                  choices: [
                    {
                      label:
                        i18n.str`Clearly defined, transparent, easily comprehensible business activity well known to the member`,
                      value: "low",
                    },
                    {
                      label:
                        i18n.str`Business activity with a high level of cash transactions`,
                      value: "medium-cash",
                    },
                    {
                      label:
                        i18n.str`Business activity not well known to the member`,
                      value: "medium-unknown",
                    },
                    {
                      label:
                        i18n.str`Trade in munitions/arms, raw gem stones/diamonds, jewelry, international trade in exotic animals, casino and lottery business, trade in erotic wares`,
                      value: "high-restricted",
                    },
                    {
                      label:
                        i18n.str`Member has no personal knowledge of the customer's industry`,
                      value: "high-unknown",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`e) Contact risk`,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    i18n.str`Types of contact to the customer/ beneficial owner of the assets`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.contact.risk",
                  choices: [
                    {
                      label:
                        i18n.str`Personal acquaintance between member and customer/beneficial owner of the assets over several years (at least 2) prior to entering into the business relationship`,
                      value: "low",
                    },
                    {
                      label:
                        i18n.str`The customer/beneficial owner was not personally known to the member for several years (at least 2) prior to entering into the business relationship; however (a) no business was entered into in the absence of the customer/beneficial owner, or (b) the customer was at least introduced/brokered by a trusted third party`,
                      value: "medium",
                    },
                    {
                      label:
                        i18n.str`The customer/beneficial owner was not personally known to the member and business was entered into in the absence of the former (relationship by correspondence) and the customer was not introduced/brokered by a trusted third party`,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`f) Product risk`,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    i18n.str`Nature of services and products requested by the customer`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.product.risk",
                  choices: [
                    {
                      label:
                        i18n.str`Easy to understand, transparent services and products whose financial background is easy to comprehend and verify`,
                      value: "low",
                    },
                    {
                      label:
                        i18n.str`More sophisticated services/products whose financial background is not readily easy to comprehend and verify`,
                      value: "medium",
                    },
                    {
                      label:
                        i18n.str`Main focus on offshore business (especially: relationships with domiciliary companies or other such offshore organisations)`,
                      value: "high-offshore",
                    },
                    {
                      label:
                        i18n.str`Complex structures in particular by using a domiciliary company with fiduciary shareholders in a non-transparent jurisdiction, without comprehensible reason or for the purpose of short-term asset placement`,
                      value: "high-structure",
                    },
                    {
                      label:
                        i18n.str`The customer or beneficial owner of the assets has a large number of accounts with pass-through transactions (pass-through accounts)`,
                      value: "high-accounts",
                    },
                    {
                      label:
                        i18n.str`Complex services/products whose financial background can’t be understood or verified with considerable effort`,
                      value: "high-service",
                    },
                    {
                      label:
                        i18n.str`Frequent transactions with increased risks`,
                      value: "high-freq-tx",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: i18n.str`g) Criteria defined by the member`,
            fields: [
              {
                type: "text",
                props: {
                  label: i18n.str`Criteria definition`,
                  name: "evaluation.custom.definition",
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.custom.risk",
                  choices: [
                    {
                      label: i18n.str`Low`,
                      value: "low",
                    },
                    {
                      label: i18n.str`Medium`,
                      value: "medium",
                    },
                    {
                      label: i18n.str`High`,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "caption",
          props: {
            label:
              i18n.str`Overall assessment of the business relationship`,
          },
        },
        {
          type: "group",
          props: {
            before:
              i18n.str`A business relationship is classified as increased risk if:`,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    i18n.str`Business relationship with PEP pursuant to numeral 1 (no exception possible)`,
                  before: create(ChevronRightIcon, { class: "h-6 w-6" }),
                },
              },
              {
                type: "caption",
                props: {
                  label:
                    'Relationship with a person from a "high risk" or non-cooperative country according to numeral 2 (no exceptions possible)' as TranslatedString,
                  before: create(ChevronRightIcon, { class: "h-6 w-6" }),
                },
              },
              {
                type: "caption",
                props: {
                  label:
                    i18n.str`Min. one criterion pursuant to numeral 3 was assessed with risk 2 or min. two criteria pursuant to numeral 3 were assessed with risk 1 (exception: justification by the member below why the business relationship overall does not have to be classified as increased risk despite the fact that individual risk criteria are increased)`,
                  before: create(ChevronRightIcon, { class: "h-6 w-6" }),
                },
              },
            ],
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Justification for differing risk assessment`,
            name: "evaluation.overall.justification",
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Risk classified`,
            name: "evaluation.overall.risk",
            choices: [
              {
                label:
                  i18n.str`Business relationship _without_ increased risk`,
                value: "without",
              },
              {
                label:
                  i18n.str`Business relationship __with__ increased risk`,
                value: "with",
              },
            ],
          },
        },
        {
          type: "absoluteTime",
          props: {
            label:
              i18n.str`The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on`,
            name: "evaluation.when",
            pattern: "dd/MM/yyyy",
            // placeholder: i18n.str`dd/MM/yyyy`,
          },
        },
      ],
    },
    {
      title:
        i18n.str`Criteria for identification of increased risk transactions (transaction monitoring)`,
      fields: [
        {
          type: "group",
          props: {
            before: i18n.str`Criteria`,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    i18n.str`Classification as as increased risk is compulsory if`,
                },
              },
              {
                type: "caption",
                props: {
                  before: create(ChevronRightIcon, { class: "w-6 h-6" }),
                  label:
                    i18n.str`Transactions for which assets with an equivalent value of CHF 100'000.- or more are physically introduced at the beginning of the business relationship, either at once or in a staggered manner`,
                },
              },
              {
                type: "caption",
                props: {
                  before: create(ChevronRightIcon, { class: "w-6 h-6" }),
                  label:
                    'Money and asset transfers ("money transfer") whereby a single transaction or multiple transactions which appear to be related reach or exceed the amount of CHF 5,000.-' as TranslatedString,
                },
              },
              {
                type: "caption",
                props: {
                  before: create(ChevronRightIcon, { class: "w-6 h-6" }),
                  label:
                    'Payments from or to a country that is considered to be "high risk" or non-cooperative by the FATF and for which increased diligence is required' as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before:
              i18n.str`Additional criteria defined by the member`,
            fields: [
              {
                type: "caption",
                props: {
                  before: create(ArrowRightIcon, { class: "w-6 h-6" }),
                  label:
                    i18n.str`All members have to define min. 1 additional criterion for every business relationship to identify unusual transactions`,
                },
              },
              {
                type: "textArea",
                props: {
                  label: i18n.str`Description`,
                  name: "criteria.additional",
                },
              },
              {
                type: "group",
                props: {
                  before:
                    i18n.str`Possible criteria (Art. 59 para. 2 SRO Regulations)`,
                  fields: [
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          i18n.str`the amount of inflowing and outflowing assets`,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          i18n.str`type, volume and frequency of transactions usual to the business relationship (considerable variance would be unusual)`,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          i18n.str`type, volume and frequency of transactions usual to comparable business relationships (considerable variance would be unusual)`,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          i18n.str`description of expected transaction patterns which the client notify the member of (considerable variance would be unusual)`,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          'The country of origin or destination of payments, especially in the case of payments from or to a country considered by the FATF as "high risk" or non-cooperative' as TranslatedString,
                      },
                    },
                  ],
                },
              },
            ],
          },
        },
      ],
    },
    resolutionSection(current, i18n),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_4.Form>,
  ): FormState<Form902_4.Form> {
    return {
    };
  },
});

namespace Form902_4 {
  export interface Form extends BaseForm {
    customer: string;
    fullName: string;
    pep: {
      foreign: "yes" | "no";
      domestic: "yes" | "no" | "yes-but-no-risk";
      when: AbsoluteTime;
    };
    highRisk: {
      evaluation: "yes" | "no";
      when: AbsoluteTime;
    };
    evaluation: {
      nationality: {
        address: "customer" | "owner" | "controlling";
        nationality: "customer" | "owner";
        risk: "low" | "medium" | "high";
      };
      business: {
        place: "customer" | "owner";
        risk: "low" | "medium" | "high";
      };
      payments: {
        risk: "low" | "medium" | "high";
      };
      industry: {
        nature: "customer" | "owner";
        risk:
        | "low"
        | "medium-cash"
        | "medium-unknown"
        | "high-restricted"
        | "high-unknown";
      };
      contact: {
        risk: "low" | "medium" | "high";
      };
      product: {
        risk:
        | "low"
        | "medium"
        | "high-offshore"
        | "high-structure"
        | "high-accounts"
        | "high-service"
        | "high-freq-tx";
      };
      custom: {
        definition: string;
        risk: "low" | "medium" | "high";
      };
      overall: {
        justification: string;
        risk: "with" | "without";
      };
    };
    criteria: {
      additional: string;
    };
  }
}
