import { TranslationProvider } from "@gnu-taler/web-util/browser";
import { h, VNode } from "preact";
import { ExchangeAmlFrame } from "./Dashboard.js";
import "./scss/main.css";
import { ExchangeApiProvider } from "./context/config.js";
import { getInitialBackendBaseURL } from "./hooks/useBackend.js";
import { HashPathProvider, Router } from "./route.js";
import { Pages } from "./pages.js";

const pageList = Object.values(Pages);


export function App(): VNode {
  const baseUrl = getInitialBackendBaseURL();
  return (
    <TranslationProvider source={{}}>
      <ExchangeApiProvider baseUrl={baseUrl} frameOnError={ExchangeAmlFrame}>
        <HashPathProvider>
          <ExchangeAmlFrame>
            <Router
              pageList={pageList}
              onNotFound={() => {
                window.location.href = Pages.cases.url
                return <div>not found</div>;
              }}
            />
          </ExchangeAmlFrame>
        </HashPathProvider>
      </ExchangeApiProvider>
    </TranslationProvider>
  );
}
