import { Fragment, VNode, h } from "preact"
import { Attention, useNotifications } from "../index.browser.js"

export function GlobalNotificationsBanner(): VNode {
  const notifs = useNotifications()
  if (notifs.length === 0) return <Fragment />
  return <div class="fixed z-20 w-full p-4"> {
    notifs.map(n => {
      switch (n.message.type) {
        case "error":
          return <Attention type="danger" title={n.message.title} onClose={() => {
            n.remove()
          }}>
            {n.message.description &&
              <div class="mt-2 text-sm text-red-700">
                {n.message.description}
              </div>
            }
            {/* <MaybeShowDebugInfo info={n.message.debug} /> */}
          </Attention>
        case "info":
          return <Attention type="success" title={n.message.title} onClose={() => {
            n.remove();
          }} />
      }
    })}
  </div>
}
