/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { HttpResponse } from "@gnu-taler/web-util/browser";
import { ErrorAlertView } from "../../components/CurrentAlerts.js";
import { Loading } from "../../components/Loading.js";
import { ErrorAlert } from "../../context/alert.js";
import { TextFieldHandler } from "../../mui/handlers.js";
import { compose, StateViewMap } from "../../utils/index.js";
import { useComponentState } from "./state.js";
import { ConfirmView, VerifyView } from "./views.js";

export interface Props {
  currency?: string;
  onBack: () => Promise<void>;
  noDebounce?: boolean;
}

export type State = State.Loading
  | State.LoadingUriError
  | State.Confirm
  | State.Verify;

export namespace State {
  export interface Loading {
    status: "loading";
    error: undefined;
  }

  export interface LoadingUriError {
    status: "error";
    error: ErrorAlert;
  }

  export interface BaseInfo {
    error: undefined;
  }
  export interface Confirm extends BaseInfo {
    status: "confirm";
    url: string;
    onCancel: () => Promise<void>;
    onConfirm: () => Promise<void>;
    error: undefined;
  }
  export interface Verify extends BaseInfo {
    status: "verify";
    error: undefined;

    onCancel: () => Promise<void>;
    onAccept: () => Promise<void>;

    url: TextFieldHandler,
    knownExchanges: URL[],
    result: HttpResponse<{ currency_specification: {currency: string}, version: string}, unknown> | undefined,
    expectedCurrency: string | undefined,
  }
}

const viewMapping: StateViewMap<State> = {
  loading: Loading,
  error: ErrorAlertView,
  confirm: ConfirmView,
  verify: VerifyView,
};

export const AddExchange = compose(
  "AddExchange",
  (p: Props) => useComponentState(p),
  viewMapping,
);
