/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import * as tests from "@gnu-taler/web-util/testing";
import { TalerActionFound as TestedComponent } from "./TalerActionFound.js";

export default {
  title: "TalerActionFound",
};

export const PayAction = tests.createExample(TestedComponent, {
  url: "taler://pay/something",
});

export const WithdrawalAction = tests.createExample(TestedComponent, {
  url: "taler://withdraw/something",
});

export const TipAction = tests.createExample(TestedComponent, {
  url: "taler://tip/something",
});

export const NotifyAction = tests.createExample(TestedComponent, {
  url: "taler://notify-reserve/something",
});

export const RefundAction = tests.createExample(TestedComponent, {
  url: "taler://refund/something",
});

export const InvalidAction = tests.createExample(TestedComponent, {
  url: "taler://something/asd",
});
