/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { ExchangeTosStatus } from "@gnu-taler/taler-util";
import { Fragment, h, VNode } from "preact";
import { CheckboxOutlined } from "../../components/CheckboxOutlined.js";
import { ExchangeXmlTos } from "../../components/ExchangeToS.js";
import {
  LinkSuccess,
  TermsOfService,
  WarningBox,
  WarningText,
} from "../../components/styled/index.js";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Button } from "../../mui/Button.js";
import { State } from "./index.js";

export function ShowButtonsAcceptedTosView({
  termsAccepted,
  showingTermsOfService,
}: State.ShowButtonsAccepted): VNode {
  const { i18n } = useTranslationContext();
  const ableToReviewTermsOfService =
    showingTermsOfService.button.onClick !== undefined;

  return (
    <Fragment>
      {ableToReviewTermsOfService && (
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          <LinkSuccess
            upperCased
            onClick={showingTermsOfService.button.onClick}
          >
            <i18n.Translate>Show terms of service</i18n.Translate>
          </LinkSuccess>
        </section>
      )}
      <section style={{ justifyContent: "space-around", display: "flex" }}>
        <CheckboxOutlined
          name="terms"
          enabled={termsAccepted.value}
          label={
            <i18n.Translate>
              I accept the exchange terms of service
            </i18n.Translate>
          }
          onToggle={termsAccepted.button.onClick}
        />
      </section>
    </Fragment>
  );
}

export function ShowButtonsNonAcceptedTosView({
  showingTermsOfService,
  terms,
}: State.ShowButtonsNotAccepted): VNode {
  const { i18n } = useTranslationContext();
  // const ableToReviewTermsOfService =
  //   showingTermsOfService.button.onClick !== undefined;

  // if (!ableToReviewTermsOfService) {
  //   return (
  //     <Fragment>
  //       {terms.status === ExchangeTosStatus.Pending && (
  //         <section style={{ justifyContent: "space-around", display: "flex" }}>
  //           <WarningText>
  //             <i18n.Translate>
  //               Exchange doesn&apos;t have terms of service
  //             </i18n.Translate>
  //           </WarningText>
  //         </section>
  //       )}
  //     </Fragment>
  //   );
  // }

  return (
    <Fragment>
      {/* {terms.status === ExchangeTosStatus.NotFound && (
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          <WarningText>
            <i18n.Translate>
              Exchange doesn&apos;t have terms of service
            </i18n.Translate>
          </WarningText>
        </section>
      )} */}
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          <Button
            variant="contained"
            color="success"
            onClick={showingTermsOfService.button.onClick}
          >
            <i18n.Translate>Review exchange terms of service</i18n.Translate>
          </Button>
        </section>
    </Fragment>
  );
}

export function ShowTosContentView({
  termsAccepted,
  showingTermsOfService,
  terms,
}: State.ShowContent): VNode {
  const { i18n } = useTranslationContext();
  const ableToReviewTermsOfService =
    showingTermsOfService?.button.onClick !== undefined;

  return (
    <Fragment>
      {!terms.content && (
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          <WarningBox>
            <i18n.Translate>
              The exchange replied with a empty terms of service
            </i18n.Translate>
          </WarningBox>
        </section>
      )}
      {terms.content && (
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          {terms.content.type === "xml" &&
            (!terms.content.document ? (
              <WarningBox>
                <i18n.Translate>
                  No terms of service. The exchange replied with a empty
                  document
                </i18n.Translate>
              </WarningBox>
            ) : (
              <TermsOfService>
                <ExchangeXmlTos doc={terms.content.document} />
              </TermsOfService>
            ))}
          {terms.content.type === "plain" &&
            (!terms.content.content ? (
              <WarningBox>
                <i18n.Translate>
                  No terms of service. The exchange replied with a empty text
                </i18n.Translate>
              </WarningBox>
            ) : (
              <div style={{ textAlign: "left" }}>
                <pre>{terms.content.content}</pre>
              </div>
            ))}
          {terms.content.type === "html" && (
            <iframe src={terms.content.href.toString()} />
          )}
          {terms.content.type === "pdf" && (
            <a href={terms.content.location.toString()} download="tos.pdf">
              <i18n.Translate>Download Terms of Service</i18n.Translate>
            </a>
          )}
        </section>
      )}
      {showingTermsOfService && ableToReviewTermsOfService && (
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          <LinkSuccess
            upperCased
            onClick={showingTermsOfService.button.onClick}
          >
            <i18n.Translate>Hide terms of service</i18n.Translate>
          </LinkSuccess>
        </section>
      )}
      {termsAccepted && terms.status !== ExchangeTosStatus.Accepted && (
        <section style={{ justifyContent: "space-around", display: "flex" }}>
          <CheckboxOutlined
            name="terms"
            enabled={termsAccepted.value}
            label={
              <i18n.Translate>
                I accept the exchange terms of service
              </i18n.Translate>
            }
            onToggle={termsAccepted.button.onClick}
          />
        </section>
      )}
    </Fragment>
  );
}
