#!/usr/bin/env node
/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { build } from "@gnu-taler/web-util/build";
import linaria from "@linaria/esbuild";

await build({
  type: "production",
  source: {
    js: [
      "src/popupEntryPoint.tsx",
      "src/walletEntryPoint.tsx",
      "src/background.ts",
      "src/taler-wallet-interaction-loader.ts",
      "src/taler-wallet-interaction-support.ts",
      "src/browserWorkerEntry.ts",
    ],
  },
  destination: "./dist/prod",
  css: "linaria",
  linariaPlugin: () => {
    // linaria has a bug if this run in web-util library
    return linaria({
      babelOptions: {
        presets: [
          "@babel/preset-typescript",
          "@babel/preset-react",
          "@linaria",
        ],
      },
      sourceMap: true,
    });
  },
});
