/*
 This file is part of GNU Taler
 (C) 2019-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Protocol version spoken with the exchange.
 *
 * Uses libtool's current:revision:age versioning.
 */
export const WALLET_EXCHANGE_PROTOCOL_VERSION = "17:0:0";

/**
 * Protocol version spoken with the merchant.
 *
 * Uses libtool's current:revision:age versioning.
 */
export const WALLET_MERCHANT_PROTOCOL_VERSION = "5:0:1";

/**
 * Protocol version spoken with the bank.
 *
 * Uses libtool's current:revision:age versioning.
 */
export const WALLET_BANK_INTEGRATION_PROTOCOL_VERSION = "0:0:0";

/**
 * Semver of the wallet-core implementation.
 * Will be replaced with the value from package.json in a
 * post-compilation step (inside lib/).
 */
export const WALLET_CORE_IMPLEMENTATION_VERSION = "1:0:0";

/**
 * Libtool rules:
 * 
 * If the library source code has changed at all since the last update, 
 *     then increment revision (‘c:r:a’ becomes ‘c:r+1:a’).
 * If any interfaces have been added, removed, or changed since the last
 *     update, increment current, and set revision to 0.
 * If any interfaces have been added since the last public release, then 
 *     increment age.
 * If any interfaces have been removed or changed since the last public 
 *     release, then set age to 0.
 */