import { base64FromArrayBuffer } from "../base64.js";
import { HttpResponse, readSuccessResponseJsonOrThrow, readTalerErrorResponse } from "../http-common.js";
import { Codec, TalerError, TalerErrorCode, TalerErrorDetail } from "../index.js";
import { stringToBytes } from "../taler-crypto.js";
import { AccessToken, PaginationParams } from "./types.js";

/**
 * Helper function to generate the "Authorization" HTTP header.
 */
export function makeBasicAuthHeader(username: string, password: string): string {
  const auth = `${username}:${password}`;
  const authEncoded: string = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}

/**
 * rfc8959
 * @param token 
 * @returns 
 */
export function makeBearerTokenAuthHeader(token: AccessToken): string {
  return `Bearer secret-token:${token}`;
}

/**
 * https://bugs.gnunet.org/view.php?id=7949
 */
export function addPaginationParams(url: URL, pagination?: PaginationParams) {
  if (!pagination) return;
  if (pagination.timoutMs) {
    url.searchParams.set("long_poll_ms", String(pagination.timoutMs))
  }
  if (pagination.offset) {
    url.searchParams.set("start", pagination.offset)
  }
  const order = !pagination || pagination.order === "asc" ? 1 : -1
  const limit = !pagination || !pagination.limit || pagination.limit === 0 ? 5 : Math.abs(pagination.limit)
  //always send delta
  url.searchParams.set("delta", String(order * limit))
}
