/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { defaultCoinConfig } from "../harness/denomStructures.js";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV2,
  createWalletDaemonWithClient,
  makeTestPaymentV2,
  withdrawViaBankV2,
} from "../harness/helpers.js";
import { AmountString } from "@gnu-taler/taler-util";

/**
 * Run test for basic, bank-integrated withdrawal and payment.
 */
export async function runAgeRestrictionsMixedMerchantTest(t: GlobalTestState) {
  // Set up test environment

  const {
    walletClient: walletOne,
    bank,
    exchange,
    merchant,
  } = await createSimpleTestkudosEnvironmentV2(
    t,
    defaultCoinConfig.map((x) => x("TESTKUDOS")),
    {
      ageMaskSpec: "8:10:12:14:16:18:21",
      mixedAgeRestriction: true,
    },
  );

  const { walletClient: walletTwo } = await createWalletDaemonWithClient(t, {
    name: "w2",
  });

  const { walletClient: walletThree } = await createWalletDaemonWithClient(t, {
    name: "w3",
  });

  {
    const walletClient = walletOne;

    const wres = await withdrawViaBankV2(t, {
      walletClient,
      bank,
      exchange,
      amount: "TESTKUDOS:20" as AmountString,
      restrictAge: 13,
    });

    await wres.withdrawalFinishedCond;

    const order = {
      summary: "Buy me!",
      amount: "TESTKUDOS:5" as AmountString,
      fulfillment_url: "taler://fulfillment-success/thx",
      minimum_age: 9,
    };

    await makeTestPaymentV2(t, { walletClient, merchant, order });
    await walletClient.call(
      WalletApiOperation.TestingWaitTransactionsFinal,
      {},
    );
  }

  {
    const wres = await withdrawViaBankV2(t, {
      walletClient: walletTwo,
      bank,
      exchange,
      amount: "TESTKUDOS:20" as AmountString,
      restrictAge: 13,
    });


    await wres.withdrawalFinishedCond;

    const order = {
      summary: "Buy me!",
      amount: "TESTKUDOS:5" as AmountString,
      fulfillment_url: "taler://fulfillment-success/thx",
    };

    await makeTestPaymentV2(t, { walletClient: walletTwo, merchant, order });
    await walletTwo.call(WalletApiOperation.TestingWaitTransactionsFinal, {});
  }

  {
    const wres = await withdrawViaBankV2(t, {
      walletClient: walletThree,
      bank,
      exchange,
      amount: "TESTKUDOS:20" as AmountString,
    });


    await wres.withdrawalFinishedCond;

    const order = {
      summary: "Buy me!",
      amount: "TESTKUDOS:5",
      fulfillment_url: "taler://fulfillment-success/thx",
      minimum_age: 9,
    };

    await makeTestPaymentV2(t, { walletClient: walletThree, merchant, order });
    await walletThree.call(WalletApiOperation.TestingWaitTransactionsFinal, {});
  }
}

runAgeRestrictionsMixedMerchantTest.suites = ["wallet"];
