import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, VNode, h } from "preact";
import { Cashouts } from "../../components/Cashouts/index.js";
import { useBackendState } from "../../hooks/backend.js";
import { ProfileNavigation } from "../ProfileNavigation.js";
import { CreateNewAccount } from "../admin/CreateNewAccount.js";
import { CreateCashout } from "../business/CreateCashout.js";

interface Props {
  account: string,
  onClose: () => void,
  onSelected: (cid: number) => void
}

export function CashoutListForAccount({ account, onSelected, onClose }: Props): VNode {
  const { i18n } = useTranslationContext();

  const { state: credentials } = useBackendState();

  const accountIsTheCurrentUser = credentials.status === "loggedIn" ?
    credentials.username === account : false

  return <Fragment>
    {accountIsTheCurrentUser ?
      <ProfileNavigation current="cashouts" />
      :
      <h1 class="text-base font-semibold leading-6 text-gray-900">
        <i18n.Translate>Cashout for account {account}</i18n.Translate>
      </h1>
    }

    <CreateCashout focus onCancel={onClose} onComplete={() => { }} account={account} />

    <Cashouts
      account={account}
      onSelected={onSelected}
    />
  </Fragment>
}

