/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import {
  Logger,
  parseWithdrawUri,
  stringifyWithdrawUri
} from "@gnu-taler/taler-util";
import {
  useTranslationContext
} from "@gnu-taler/web-util/browser";
import { Fragment, VNode, h } from "preact";
import { Attention } from "@gnu-taler/web-util/browser";
import { useBankCoreApiContext } from "../context/config.js";
import { usePreferences } from "../hooks/preferences.js";
import { WithdrawalQRCode } from "./WithdrawalQRCode.js";

const logger = new Logger("AccountPage");

export function WithdrawalOperationPage({
  operationId,
  onContinue,
}: {
  operationId: string;
  onContinue: () => void;
}): VNode {
  const { api } = useBankCoreApiContext()
  const uri = stringifyWithdrawUri({
    bankIntegrationApiBaseUrl: api.getIntegrationAPI().baseUrl,
    withdrawalOperationId: operationId,
  });
  const parsedUri = parseWithdrawUri(uri);
  const { i18n } = useTranslationContext();
  const [settings, updateSettings] = usePreferences();

  if (!parsedUri) {
    return <Attention type="danger" title={i18n.str`The Withdrawal URI is not valid`}>
      {uri}
    </Attention>
  }

  return (
    <WithdrawalQRCode
      withdrawUri={parsedUri}
      onClose={() => {
        updateSettings("currentWithdrawalOperationId", undefined)
        onContinue()
      }}
    />
  );
}

export function assertUnreachable(x: never): never {
  throw new Error("Didn't expect to get here");
}
