import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, VNode, h } from "preact";
import { useBankCoreApiContext } from "../context/config.js";
import { assertUnreachable } from "./WithdrawalOperationPage.js";

export function ProfileNavigation({ current, noCashout }: { noCashout?: boolean, current: "details" | "credentials" | "cashouts" }): VNode {
  const { i18n } = useTranslationContext()
  const { config } = useBankCoreApiContext()
  return <div>
    <div class="sm:hidden">
      <label for="tabs" class="sr-only"><i18n.Translate>Select a section</i18n.Translate></label>
      <select id="tabs" name="tabs" class="block w-full rounded-md border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" onChange={(e) => {
        const op = e.currentTarget.value as typeof current
        switch (op) {
          case "details": {
            window.location.href = "#/my-profile";
            return;
          }
          case "credentials": {
            window.location.href = "#/my-password";
            return;
          }
          case "cashouts": {
            window.location.href = "#/my-cashouts";
            return;
          }
          default: assertUnreachable(op)
        }
      }}>
        <option value="details" selected={current == "details"}><i18n.Translate>Details</i18n.Translate></option>
        <option value="credentials" selected={current == "credentials"}><i18n.Translate>Credentials</i18n.Translate></option>
        {config.allow_conversion ?
          <option value="cashouts" selected={current == "cashouts"}><i18n.Translate>Cashouts</i18n.Translate></option>
          : undefined}
      </select>
    </div>
    <div class="hidden sm:block">
      <nav class="isolate flex divide-x divide-gray-200 rounded-lg shadow" aria-label="Tabs">
        <a href="#/my-profile" data-selected={current == "details"} class="rounded-l-lg text-gray-500 hover:text-gray-700 data-[selected=true]:text-gray-900 group relative min-w-0 flex-1 overflow-hidden bg-white py-4 px-4 text-center text-sm font-medium hover:bg-gray-50 focus:z-10" >
          <span><i18n.Translate>Details</i18n.Translate></span>
          <span aria-hidden="true" data-selected={current == "details"} class="bg-transparent data-[selected=true]:bg-indigo-500 absolute inset-x-0 bottom-0 h-0.5"></span>
        </a>
        <a href="#/my-password" data-selected={current == "credentials"} aria-current="page" class="             text-gray-500 hover:text-gray-700 data-[selected=true]:text-gray-900 group relative min-w-0 flex-1 overflow-hidden bg-white py-4 px-4 text-center text-sm font-medium hover:bg-gray-50 focus:z-10">
          <span><i18n.Translate>Credentials</i18n.Translate></span>
          <span aria-hidden="true" data-selected={current == "credentials"} class="bg-transparent data-[selected=true]:bg-indigo-500 absolute inset-x-0 bottom-0 h-0.5"></span>
        </a>
        {config.allow_conversion && !noCashout ?
          <a href="#/my-cashouts" data-selected={current == "cashouts"} class="rounded-r-lg text-gray-500 hover:text-gray-700 data-[selected=true]:text-gray-900 group relative min-w-0 flex-1 overflow-hidden bg-white py-4 px-4 text-center text-sm font-medium hover:bg-gray-50 focus:z-10">
            <span>Cashouts</span>
            <span aria-hidden="true" data-selected={current == "cashouts"} class="bg-transparent data-[selected=true]:bg-indigo-500 absolute inset-x-0 bottom-0 h-0.5"></span>
          </a>
          : undefined}
      </nav>
    </div>
  </div>
}