import {
  AbsoluteTime,
  AmountJson,
  TranslatedString
} from "@gnu-taler/taler-util";
import { DoubleColumnForm, FormState } from "@gnu-taler/web-util/browser";

export namespace Data {
  export interface WithResolution {
    when: AbsoluteTime;
    threshold: AmountJson;
    state: string;
  }
  export interface Form extends WithResolution {
    comment: string;
  }
}

const design: DoubleColumnForm = [
  {
    title: "Simple form" as TranslatedString,
    fields: [
      {
        type: "textArea",
        props: {
          name: "comment",
          label: "Comments" as TranslatedString,
        },
      },
    ],
  },
  {
    title: "Resolution" as TranslatedString,
    description: `Current state is and threshold at ` as TranslatedString,
    fields: [
      {
        type: "date",
        props: {
          name: "when",
          label: "Decision Time" as TranslatedString,
        },
      },
      {
        type: "amount",
        props: {
          name: "threshold",
          label: "New threshold" as TranslatedString,
        },
      },
    ],
  }
  ,
];

function formBehavior(v: Partial<Data.Form>): FormState<Data.Form> {
  return {
    when: {
      disabled: true,
    },
    threshold: {
      // disabled: v.state === AmlExchangeBackend.AmlState.frozen,
    },
  };
}


