export namespace AmlExchangeBackend {
  // FIXME: placeholder
  export interface AmlError {
    code: number;
    hint: string;
  }
  export interface AmlDecisionDetails {
    // Array of AML decisions made for this account. Possibly
    // contains only the most recent decision if "history" was
    // not set to 'true'.
    aml_history: AmlDecisionDetail[];

    // Array of KYC attributes obtained for this account.
    kyc_attributes: KycDetail[];
  }

  type AmlOfficerPublicKeyP = string;

  export interface AmlDecisionDetail {
    // What was the justification given?
    justification: string;

    // What is the new AML state.
    new_state: Integer;

    // When was this decision made?
    decision_time: Timestamp;

    // What is the new AML decision threshold (in monthly transaction volume)?
    new_threshold: Amount;

    // Who made the decision?
    decider_pub: AmlOfficerPublicKeyP;
  }
  export interface KycDetail {
    // Name of the configuration section that specifies the provider
    // which was used to collect the KYC details
    provider_section: string;

    // The collected KYC data.  NULL if the attribute data could not
    // be decrypted (internal error of the exchange, likely the
    // attribute key was changed).
    attributes?: Object;

    // Time when the KYC data was collected
    collection_time: Timestamp;

    // Time when the validity of the KYC data will expire
    expiration_time: Timestamp;
  }

  interface Timestamp {
    // Seconds since epoch, or the special
    // value "never" to represent an event that will
    // never happen.
    t_s: number | "never";
  }

  type PaytoHash = string;
  type Integer = number;
  type Amount = string;
  // EdDSA signatures are transmitted as 64-bytes base32
  // binary-encoded objects with just the R and S values (base32_ binary-only).
  type EddsaSignature = string;

  export interface AmlRecords {
    // Array of AML records matching the query.
    records: AmlRecord[];
  }

  interface AmlRecord {
    // Which payto-address is this record about.
    // Identifies a GNU Taler wallet or an affected bank account.
    h_payto: PaytoHash;

    // What is the current AML state.
    current_state: AmlState;

    // Monthly transaction threshold before a review will be triggered
    threshold: Amount;

    // RowID of the record.
    rowid: Integer;
  }

  export enum AmlState {
    normal = 0,
    pending = 1,
    frozen = 2,
  }

  
  export interface AmlDecision {

    // Human-readable justification for the decision.
    justification: string;
  
    // At what monthly transaction volume should the
    // decision be automatically reviewed?
    new_threshold: Amount;
  
    // Which payto-address is the decision about?
    // Identifies a GNU Taler wallet or an affected bank account.
    h_payto: PaytoHash;
  
    // What is the new AML state (e.g. frozen, unfrozen, etc.)
    // Numerical values are defined in AmlDecisionState.
    new_state: Integer;
  
    // Signature by the AML officer over a
    // TALER_MasterAmlOfficerStatusPS.
    // Must have purpose TALER_SIGNATURE_MASTER_AML_KEY.
    officer_sig: EddsaSignature;
  
    // When was the decision made?
    decision_time: Timestamp;
  
    // Optional argument to impose new KYC requirements
    // that the customer has to satisfy to unblock transactions.
    kyc_requirements?: string[];
  }
  

}
