import { TranslatedString } from "@gnu-taler/taler-util";
import { AntiMoneyLaunderingForm } from "./pages/AntiMoneyLaunderingForm.js";
import { CaseDetails } from "./pages/CaseDetails.js";
import { Cases, HomeIcon, PeopleIcon } from "./pages/Cases.js";
import { NewFormEntry } from "./pages/NewFormEntry.js";
import { Officer } from "./pages/Officer.js";
import { PageEntry, pageDefinition } from "./route.js";
// import homeLogo from "./assets/home.svg";
// import peopleLogo from "./assets/people.svg";
const cases: PageEntry = {
  url: "#/cases",
  view: Cases,
  name: "Cases" as TranslatedString,
  Icon: HomeIcon,
};

const officer: PageEntry = {
  url: "#/officer",
  view: Officer,
  name: "Officer" as TranslatedString,
  Icon: PeopleIcon,
};

const account: PageEntry<{ account: string }> = {
  url: pageDefinition("#/account/:account"),
  view: CaseDetails,
  name: "Account" as TranslatedString,
  // icon: () => undefined,
};

const newFormEntry: PageEntry<{ account?: string; type?: string }> = {
  url: pageDefinition("#/account/:account/new/:type?"),
  view: NewFormEntry,
  name: "New Form" as TranslatedString,
  // icon: () => undefined,
};


export const Pages = {
  cases,
  officer,
  account,
  newFormEntry,
};
