import {
  AbsoluteTime,
  AmountJson,
  Amounts,
  TranslatedString,
} from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { DoubleColumnFormSection } from "../handlers/forms.js";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";

import { AmlExchangeBackend } from "../types.js";
import { FlexibleForm } from "./index.js";
import { amlStateConverter } from "../pages/ShowConsolidated.js";

export const v1 = (current: BaseForm): FlexibleForm<Simplest.Form> => ({
  design: [
    {
      title: "Simple form" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            name: "comment",
            label: "Comments" as TranslatedString,
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Simplest.Form>,
  ): FormState<Simplest.Form> {
    return {
      comment: {
        help: ((v.comment?.length ?? 0) > 100 ? "keep it short" : "") as TranslatedString
      },
      threshold: {
        disabled: v.state === AmlExchangeBackend.AmlState.frozen,
      },
    };
  },
});

export namespace Simplest {
  export interface Form extends BaseForm {
    comment: string;
  }
}

export function resolutionSection(current: BaseForm): DoubleColumnFormSection {
  return {
    title: "Resolution" as TranslatedString,
    description: `Current state is ${amlStateConverter.toStringUI(
      current.state,
    )} and threshold at ${Amounts.stringifyValue(
      current.threshold,
    )}` as TranslatedString,
    fields: [
      {
        type: "choiceHorizontal",
        props: {
          name: "state",
          label: "New state" as TranslatedString,
          converter: amlStateConverter,
          choices: [
            {
              value: AmlExchangeBackend.AmlState.frozen,
              label: "Frozen" as TranslatedString,
            },
            {
              value: AmlExchangeBackend.AmlState.pending,
              label: "Pending" as TranslatedString,
            },
            {
              value: AmlExchangeBackend.AmlState.normal,
              label: "Normal" as TranslatedString,
            },
          ],
        },
      },
      {
        type: "amount",
        props: {
          name: "threshold",
          label: "New threshold" as TranslatedString,
        },
      },
    ],
  };
}
