import { TranslatedString } from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { DoubleColumnForm } from "../handlers/forms.js";

export interface FlexibleForm<T extends object> {
  design: DoubleColumnForm;
  behavior?: (form: Partial<T>) => FormState<T>;
}

export const languageList = [
  {
    label: "Mandarin Chinese" as TranslatedString,
    value: "cmn",
  },
  {
    label: "Spanish" as TranslatedString,
    value: "spa",
  },
  {
    label: "English" as TranslatedString,
    value: "eng",
  },
  {
    label: "Hindi" as TranslatedString,
    value: "hin",
  },
  {
    label: "Portuguese" as TranslatedString,
    value: "por",
  },
  {
    label: "Bengali" as TranslatedString,
    value: "ben",
  },
  {
    label: "Russian" as TranslatedString,
    value: "rus",
  },
  {
    label: "Japanese" as TranslatedString,
    value: "jpn",
  },
  {
    label: "Yue" as TranslatedString,
    value: "yue",
  },
  {
    label: "Vietnamese" as TranslatedString,
    value: "vie",
  },
  {
    label: "Turkish" as TranslatedString,
    value: "tur",
  },
  {
    label: "Wu" as TranslatedString,
    value: "wuu",
  },
  {
    label: "Marathi" as TranslatedString,
    value: "mar",
  },
  {
    label: "Telugu" as TranslatedString,
    value: "ten",
  },
  {
    label: "Korean" as TranslatedString,
    value: "kor",
  },
  {
    label: "French" as TranslatedString,
    value: "fra",
  },
  {
    label: "Tamil" as TranslatedString,
    value: "tam",
  },
  {
    label: "Egyptian Arabic" as TranslatedString,
    value: "arz",
  },
  {
    label: "Standard German" as TranslatedString,
    value: "deu",
  },
  {
    label: "Urdu" as TranslatedString,
    value: "urd",
  },
  {
    label: "Javanese" as TranslatedString,
    value: "jav",
  },
  {
    label: "Punjabi" as TranslatedString,
    value: "pan",
  },
  {
    label: "Italian" as TranslatedString,
    value: "ita",
  },
  {
    label: "Gujarati" as TranslatedString,
    value: "guj",
  },
  {
    label: "Iranian Persian" as TranslatedString,
    value: "pes",
  },
  {
    label: "Bhojpuri" as TranslatedString,
    value: "bho",
  },
  {
    label: "Hausa" as TranslatedString,
    value: "hau",
  },
];
export const currencyList = [
  {
    label: "United States dollar" as TranslatedString,
    value: "usd",
  },
  {
    label: "Euro" as TranslatedString,
    value: "eur",
  },
  {
    label: "Swiss franc" as TranslatedString,
    value: "chf",
  },
  {
    label: "Argentine peso" as TranslatedString,
    value: "ars",
  },
  {
    label: "Mexican peso" as TranslatedString,
    value: "mxn",
  },
  {
    label: "Brazilian real" as TranslatedString,
    value: "brl",
  },
];
