import { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm } from "./index.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_9.Form> => ({
  design: [
    {
      title:
        "Declaration of identity of the beneficial owner" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: "Contracting partner" as TranslatedString,
          },
        },
        {
          type: "caption",
          props: {
            label:
              "The contracting partner hereby declares that the person(s) listed below is/are the beneficial owner(s) of the assets involved in the business relationship. If the contracting partner is also the sole beneficial owner of the assets, the contracting partner's detail must be set out below" as TranslatedString,
          },
        },
        {
          type: "array",
          props: {
            label: "Persons" as TranslatedString,
            labelField: "surname",
            name: "persons",
            fields: [
              {
                type: "text",
                props: {
                  name: "surname",
                  label: "Surname(s)" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "firstName",
                  label: "First name(s)" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: "Actual address of domicile" as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "caption",
          props: {
            label:
              "The contracting partner hereby undertakes to inform automatically of any changes to the information contained herein" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: "Signature" as TranslatedString,
          },
        },
        {
          type: "caption",
          props: {
            label:
              "It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)" as TranslatedString,
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_9.Form>,
  ): FormState<Form902_9.Form> {
    return {
    };
  },
});

namespace Form902_9 {
  interface Person {
    surname: string;
    firstName: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
    address: string;
  }
  export interface Form extends BaseForm {
    contractingPartner: string;
    persons: Person;
    signature: string;
  }
}
