import { TranslatedString } from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm, currencyList } from "./index.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_5.Form> => ({
  design: [
    {
      title: "Customer Profile" as TranslatedString,
      description:
        "The information below has to refer to the persons from whom the assets originate ultimately (e.g. beneficial owner of the assets, founder/creator of a trust or foundation). Is the customer an operational legal entity or partnership the information may refer to the entity itself (not to the controlling person), unless the entity holds the assets in trust for a third party." as TranslatedString,
      fields: [
        {
          type: "text",
          props: {
            name: "customer",
            label: "Customer" as TranslatedString,
            help: "Pursuant Identification Form (VQF doc. No. 902.1) numeral 1" as TranslatedString,
          },
        },
      ],
    },
    {
      title: "Business activity" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            label: "Profession, business activities" as TranslatedString,
            name: "businessActivity",
            help: "former, current, potentially planned" as TranslatedString,
          },
        },
      ],
    },
    {
      title: "Financial circumstances" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            label: "Income and assets, liabilities" as TranslatedString,
            name: "financial",
            help: "estimated" as TranslatedString,
          },
        },
      ],
    },
    {
      title: "Origin of the deposited assets involved" as TranslatedString,
      fields: [
        {
          type: "text",
          props: {
            label: "Nature" as TranslatedString,
            name: "originOfAssets.nature",
            help: "nature of the involved assets" as TranslatedString,
          },
        },
        {
          type: "selectOne",
          props: {
            name: "originOfAssets.currency",
            label: "Currency" as TranslatedString,
            choices: currencyList,
          },
        },
        {
          type: "integer",
          props: {
            label: "Amount" as TranslatedString,
            name: "originOfAssets.amount",
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: "Category" as TranslatedString,
            name: "originOfAssets.category",
            choices: [
              {
                label: "Savings" as TranslatedString,
                value: "savings",
              },
              {
                label: "Own business operations" as TranslatedString,
                value: "own-business",
              },
              {
                label: "Inheritance" as TranslatedString,
                value: "inheritance",
              },
              {
                label: "Other, what?" as TranslatedString,
                value: "other",
              },
            ],
          },
        },
        {
          type: "text",
          props: {
            label: "Other category" as TranslatedString,
            name: "originOfAssets.categoryOther",
            required: true,
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Detailed description of the origins/economical background of the assets involved in the business relationship" as TranslatedString,
            name: "originOfAssets.details",
          },
        },
      ],
    },
    {
      title:
        "Nature and purpose of the business relationship" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            label: "Purpose of the business relationship" as TranslatedString,
            name: "nature.purpose",
            help: "nature of the involved assets" as TranslatedString,
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Information on the planned development of the business relationship and the assets" as TranslatedString,
            name: "nature.plan",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Especially in the case of cash or money and asset transfer transactions with regular customers: Details on usual business volume, Information on the beneficiaries, (Full name, address, bank account)" as TranslatedString,
            name: "nature.cashOrMoneyTransfer",
          },
        },
      ],
    },
    {
      title: "Relationship with third parties" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            label:
              "Relation of the customer to the beneficial owner involved in the business relationship" as TranslatedString,
            name: "relations.beneficialOwners",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Relation of the customer to the controlling persons involved in the business relationship" as TranslatedString,
            name: "relations.controllingPersons",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Relation of the customer to the authorized signatories involved in the business relationship" as TranslatedString,
            name: "relations.authorizedSignatories",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Relation of the customer to other persons involved in the business relationship" as TranslatedString,
            name: "relations.otherPersons",
          },
        },
        {
          type: "textArea",
          props: {
            label: "Relation to other AMLA-Files" as TranslatedString,
            name: "relations.withOtherAmlaFiles",
          },
        },
        {
          type: "textArea",
          props: {
            label: "Introducer / agents / references" as TranslatedString,
            name: "relations.references",
          },
        },
      ],
    },
    {
      title: "Further information" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            label: "Other relevant information" as TranslatedString,
            name: "furtherInformation",
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_5.Form>,
  ): FormState<Form902_5.Form> {
    return {
      originOfAssets: {
        categoryOther: {
          hidden: v.originOfAssets?.category !== "other",
        },
      },
    };
  },
});

namespace Form902_5 {
  export interface Form extends BaseForm {
    customer: string;
    fullName: string;
    businessActivity: string;
    financial: string;
    originOfAssets: {
      nature: string;
      currency: string;
      amount: number;
      category: "savings" | "own-business" | "inheritance" | "other";
      categoryOther: string;
      details: string;
    };
    nature: {
      purpose: string;
      plan: string;
      cashOrMoneyTransfer: string;
    };
    relations: {
      beneficialOwners: string;
      controllingPersons: string;
      authorizedSignatories: string;
      otherPersons: string;
      withOtherAmlaFiles: string;
      references: string;
    };
    furtherInformation: string;
  }
}
