import { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import { h as create } from "preact";
import { FormState } from "../handlers/FormProvider.js";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm } from "./index.js";
import { Simplest, resolutionSection } from "./simplest.js";
import { ArrowRightIcon, ChevronRightIcon } from "../pages/Cases.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_4.Form> => ({
  design: [
    {
      title: "Risk Profile AMLA" as TranslatedString,
      description:
        "Evaluation of business relationship with increased risk and definition of criteria for transaction monitoring." as TranslatedString,
      fields: [
        {
          type: "caption",
          props: {
            label:
              "The member performs additional clarifications if the business relationship or the transaction is classified as increased risk (Art. 56 SRO Regulations)" as TranslatedString,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "text",
          props: {
            name: "customer",
            label: "Customer" as TranslatedString,
            help: "Pursuant identification form (VQF doc. Nr. 902.1) numeral 1" as TranslatedString,
          },
        },
      ],
    },
    {
      title:
        "Evaluation of politically exposed persons (PEP-Check)" as TranslatedString,
      fields: [
        {
          type: "caption",
          props: {
            label:
              "This evaluation has to be completed by all members for every business relationship" as TranslatedString,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: "Foreign PEP" as TranslatedString,
            // tooltip:
            //   "Definition see Art. 7 lit. g numeral 1 SRO Regulations" as TranslatedString,
            help: "Is the customer, the beneficial owner or the controlling person or authorized representative a foreign PEP or closely related to such a person?" as TranslatedString,
            name: "pep.foreign",
            choices: [
              {
                label: "No" as TranslatedString,
                value: "no",
              },
              {
                label: "Yes" as TranslatedString,
                description:
                  "The business relationship is compulsory  classified as increased risk" as TranslatedString,
                value: "yes",
              },
            ],
          },
        },
        {
          type: "choiceStacked",
          props: {
            label:
              "Domestic PEP and PEP of International Organizations" as TranslatedString,
            // tooltip:
            //   "Definition see Art. 7 lit. g numeral 2 and 3 SRO Regulations " as TranslatedString,
            help: "Is the customer, the beneficial owner or the controlling person or authorized representative a domestic PEP or PEP in International Organizations or closely related to such a person?" as TranslatedString,
            name: "pep.domestic",
            choices: [
              {
                label: "No" as TranslatedString,
                value: "no",
              },
              {
                label:
                  "Yes, but NOT risk criterion pursuant to numeral 3 subsequently increased." as TranslatedString,
                value: "yes-but-no-risk",
              },
              {
                label:
                  "Yes, AND a risk criterion pursuant to numeral 3 subsequently increased." as TranslatedString,
                description:
                  "Classification of the business relationship as increased risk is compulsory" as TranslatedString,
                value: "yes",
              },
            ],
          },
        },
        {
          type: "date",
          props: {
            label:
              "The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on" as TranslatedString,
            name: "pep.when",
            pattern: "dd/MM/yyyy",
            // placeholder: "dd/MM/yyyy" as TranslatedString,
          },
        },
      ],
    },
    {
      title:
        'Evaluation "high risk" or non-cooperative country' as TranslatedString,
      fields: [
        {
          type: "caption",
          props: {
            label:
              "This evaluation has to be completed by all members for every business relationship" as TranslatedString,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: '"High risk" or non-cooperative country' as TranslatedString,
            help: 'Is the customer, the beneficial owner or the controlling person or authorized representative in a country considered by the FATF "high risk" or non-cooperative and for which FATF requires increased diligence?' as TranslatedString,
            name: "highRisk.evaluation",
            choices: [
              {
                label: "No" as TranslatedString,
                value: "no",
              },
              {
                label: "Yes" as TranslatedString,
                description:
                  "considered as business relationship with increased risk" as TranslatedString,
                value: "yes",
              },
            ],
          },
        },
        {
          type: "date",
          props: {
            label:
              "The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on" as TranslatedString,
            name: "highRisk.when",
            pattern: "dd/MM/yyyy",
            // placeholder: "dd/MM/yyyy" as TranslatedString,
          },
        },
      ],
    },
    {
      title: "Evaluation of business relationship risk" as TranslatedString,
      fields: [
        {
          type: "caption",
          props: {
            label:
              "This evaluation has to be completed by all members who have in total more than 20 customers for every business relationship. At least two risk categories have to be chosen and assessed" as TranslatedString,
            before: create(ArrowRightIcon, { class: "h-6 w-6" }),
          },
        },
        {
          type: "group",
          props: {
            before: "a) Country risk (nationality)" as TranslatedString,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: "Domicile/residential address" as TranslatedString,
                  name: "evaluation.nationality.address",
                  choices: [
                    {
                      label: "Customer" as TranslatedString,
                      value: "customer",
                    },
                    {
                      label:
                        "Beneficial owner of the assets" as TranslatedString,
                      value: "owner",
                    },
                    {
                      label: "Controlling person" as TranslatedString,
                      value: "controlling",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Nationality" as TranslatedString,
                  name: "evaluation.nationality.nationality",
                  choices: [
                    {
                      label: "Customer" as TranslatedString,
                      value: "customer",
                    },
                    {
                      label:
                        "Beneficial owner of the assets" as TranslatedString,
                      value: "owner",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.nationality.risk",
                  choices: [
                    {
                      label:
                        "Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "low",
                    },
                    {
                      label:
                        "Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "medium",
                    },
                    {
                      label:
                        "Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: "b) Country risk (business activity)" as TranslatedString,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: "Place of business activity" as TranslatedString,
                  name: "evaluation.business.place",
                  choices: [
                    {
                      label: "Customer" as TranslatedString,
                      value: "customer",
                    },
                    {
                      label:
                        "Beneficial owner of the assets" as TranslatedString,
                      value: "owner",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.business.risk",
                  choices: [
                    {
                      label:
                        "Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "low",
                    },
                    {
                      label:
                        "Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "medium",
                    },
                    {
                      label:
                        "Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: "c) Country risk (payments)" as TranslatedString,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    "Country of origin and destination of frequent payments (if known)" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.payments.risk",
                  choices: [
                    {
                      label:
                        "Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "low",
                    },
                    {
                      label:
                        "Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "medium",
                    },
                    {
                      label:
                        "Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)" as TranslatedString,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: "d) Industry risk" as TranslatedString,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label:
                    "Nature of customer's business activity" as TranslatedString,
                  name: "evaluation.industry.nature",
                  choices: [
                    {
                      label: "Customer" as TranslatedString,
                      value: "customer",
                    },
                    {
                      label:
                        "Beneficial owner of the assets" as TranslatedString,
                      value: "owner",
                    },
                  ],
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.payments.risk",
                  choices: [
                    {
                      label:
                        "Clearly defined, transparent, easily comprehensible business activity well known to the member" as TranslatedString,
                      value: "low",
                    },
                    {
                      label:
                        "Business activity with a high level of cash transactions" as TranslatedString,
                      value: "medium-cash",
                    },
                    {
                      label:
                        "Business activity not well known to the member" as TranslatedString,
                      value: "medium-unknown",
                    },
                    {
                      label:
                        "Trade in munitions/arms, raw gem stones/diamonds, jewelry, international trade in exotic animals, casino and lottery business, trade in erotic wares" as TranslatedString,
                      value: "high-restricted",
                    },
                    {
                      label:
                        "Member has no personal knowledge of the customer's industry" as TranslatedString,
                      value: "high-unknown",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: "e) Contact risk" as TranslatedString,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    "Types of contact to the customer/ beneficial owner of the assets" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.contact.risk",
                  choices: [
                    {
                      label:
                        "Personal acquaintance between member and customer/beneficial owner of the assets over several years (at least 2) prior to entering into the business relationship" as TranslatedString,
                      value: "low",
                    },
                    {
                      label:
                        "The customer/beneficial owner was not personally known to the member for several years (at least 2) prior to entering into the business relationship; however (a) no business was entered into in the absence of the customer/beneficial owner, or (b) the customer was at least introduced/brokered by a trusted third party" as TranslatedString,
                      value: "medium",
                    },
                    {
                      label:
                        "The customer/beneficial owner was not personally known to the member and business was entered into in the absence of the former (relationship by correspondence) and the customer was not introduced/brokered by a trusted third party" as TranslatedString,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: "f) Product risk" as TranslatedString,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    "Nature of services and products requested by the customer" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.product.risk",
                  choices: [
                    {
                      label:
                        "Easy to understand, transparent services and products whose financial background is easy to comprehend and verify" as TranslatedString,
                      value: "low",
                    },
                    {
                      label:
                        "More sophisticated services/products whose financial background is not readily easy to comprehend and verify" as TranslatedString,
                      value: "medium",
                    },
                    {
                      label:
                        "Main focus on offshore business (especially: relationships with domiciliary companies or other such offshore organisations)" as TranslatedString,
                      value: "high-offshore",
                    },
                    {
                      label:
                        "Complex structures in particular by using a domiciliary company with fiduciary shareholders in a non-transparent jurisdiction, without comprehensible reason or for the purpose of short-term asset placement" as TranslatedString,
                      value: "high-structure",
                    },
                    {
                      label:
                        "The customer or beneficial owner of the assets has a large number of accounts with pass-through transactions (pass-through accounts)" as TranslatedString,
                      value: "high-accounts",
                    },
                    {
                      label:
                        "Complex services/products whose financial background can’t be understood or verified with considerable effort" as TranslatedString,
                      value: "high-service",
                    },
                    {
                      label:
                        "Frequent transactions with increased risks" as TranslatedString,
                      value: "high-freq-tx",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before: "g) Criteria defined by the member" as TranslatedString,
            fields: [
              {
                type: "text",
                props: {
                  label: "Criteria definition" as TranslatedString,
                  name: "evaluation.custom.definition",
                },
              },
              {
                type: "choiceStacked",
                props: {
                  label: "Risk level" as TranslatedString,
                  name: "evaluation.custom.risk",
                  choices: [
                    {
                      label: "Low" as TranslatedString,
                      value: "low",
                    },
                    {
                      label: "Medium" as TranslatedString,
                      value: "medium",
                    },
                    {
                      label: "High" as TranslatedString,
                      value: "high",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "caption",
          props: {
            label:
              "Overall assessment of the business relationship" as TranslatedString,
          },
        },
        {
          type: "group",
          props: {
            before:
              "A business relationship is classified as increased risk if:" as TranslatedString,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    "Business relationship with PEP pursuant to numeral 1 (no exception possible)" as TranslatedString,
                  before: create(ChevronRightIcon, { class: "h-6 w-6" }),
                },
              },
              {
                type: "caption",
                props: {
                  label:
                    'Relationship with a person from a "high risk" or non-cooperative country according to numeral 2 (no exceptions possible)' as TranslatedString,
                  before: create(ChevronRightIcon, { class: "h-6 w-6" }),
                },
              },
              {
                type: "caption",
                props: {
                  label:
                    "Min. one criterion pursuant to numeral 3 was assessed with risk 2 or min. two criteria pursuant to numeral 3 were assessed with risk 1 (exception: justification by the member below why the business relationship overall does not have to be classified as increased risk despite the fact that individual risk criteria are increased)" as TranslatedString,
                  before: create(ChevronRightIcon, { class: "h-6 w-6" }),
                },
              },
            ],
          },
        },
        {
          type: "textArea",
          props: {
            label:
              "Justification for differing risk assessment" as TranslatedString,
            name: "evaluation.overall.justification",
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: "Risk classified" as TranslatedString,
            name: "evaluation.overall.risk",
            choices: [
              {
                label:
                  "Business relationship _without_ increased risk" as TranslatedString,
                value: "without",
              },
              {
                label:
                  "Business relationship __with__ increased risk" as TranslatedString,
                value: "with",
              },
            ],
          },
        },
        {
          type: "date",
          props: {
            label:
              "The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on" as TranslatedString,
            name: "evaluation.when",
            pattern: "dd/MM/yyyy",
            // placeholder: "dd/MM/yyyy" as TranslatedString,
          },
        },
      ],
    },
    {
      title:
        "Criteria for identification of increased risk transactions (transaction monitoring)" as TranslatedString,
      fields: [
        {
          type: "group",
          props: {
            before: "Criteria" as TranslatedString,
            fields: [
              {
                type: "caption",
                props: {
                  label:
                    "Classification as as increased risk is compulsory if" as TranslatedString,
                },
              },
              {
                type: "caption",
                props: {
                  before: create(ChevronRightIcon, { class: "w-6 h-6" }),
                  label:
                    "Transactions for which assets with an equivalent value of CHF 100'000.- or more are physically introduced at the beginning of the business relationship, either at once or in a staggered manner" as TranslatedString,
                },
              },
              {
                type: "caption",
                props: {
                  before: create(ChevronRightIcon, { class: "w-6 h-6" }),
                  label:
                    'Money and asset transfers ("money transfer") whereby a single transaction or multiple transactions which appear to be related reach or exceed the amount of CHF 5,000.-' as TranslatedString,
                },
              },
              {
                type: "caption",
                props: {
                  before: create(ChevronRightIcon, { class: "w-6 h-6" }),
                  label:
                    'Payments from or to a country that is considered to be "high risk" or non-cooperative by the FATF and for which increased diligence is required' as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before:
              "Additional criteria defined by the member" as TranslatedString,
            fields: [
              {
                type: "caption",
                props: {
                  before: create(ArrowRightIcon, { class: "w-6 h-6" }),
                  label:
                    "All members have to define min. 1 additional criterion for every business relationship to identify unusual transactions" as TranslatedString,
                },
              },
              {
                type: "textArea",
                props: {
                  label: "Description" as TranslatedString,
                  name: "criteria.additional",
                },
              },
              {
                type: "group",
                props: {
                  before:
                    "Possible criteria (Art. 59 para. 2 SRO Regulations)" as TranslatedString,
                  fields: [
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          "the amount of inflowing and outflowing assets" as TranslatedString,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          "type, volume and frequency of transactions usual to the business relationship (considerable variance would be unusual)" as TranslatedString,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          "type, volume and frequency of transactions usual to comparable business relationships (considerable variance would be unusual)" as TranslatedString,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          "description of expected transaction patterns which the client notify the member of (considerable variance would be unusual)" as TranslatedString,
                      },
                    },
                    {
                      type: "caption",
                      props: {
                        before: create(ChevronRightIcon, { class: "w-4 h-4" }),
                        label:
                          'The country of origin or destination of payments, especially in the case of payments from or to a country considered by the FATF as "high risk" or non-cooperative' as TranslatedString,
                      },
                    },
                  ],
                },
              },
            ],
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_4.Form>,
  ): FormState<Form902_4.Form> {
    return {
    };
  },
});

namespace Form902_4 {
  export interface Form extends BaseForm {
    customer: string;
    fullName: string;
    pep: {
      foreign: "yes" | "no";
      domestic: "yes" | "no" | "yes-but-no-risk";
      when: AbsoluteTime;
    };
    highRisk: {
      evaluation: "yes" | "no";
      when: AbsoluteTime;
    };
    evaluation: {
      nationality: {
        address: "customer" | "owner" | "controlling";
        nationality: "customer" | "owner";
        risk: "low" | "medium" | "high";
      };
      business: {
        place: "customer" | "owner";
        risk: "low" | "medium" | "high";
      };
      payments: {
        risk: "low" | "medium" | "high";
      };
      industry: {
        nature: "customer" | "owner";
        risk:
        | "low"
        | "medium-cash"
        | "medium-unknown"
        | "high-restricted"
        | "high-unknown";
      };
      contact: {
        risk: "low" | "medium" | "high";
      };
      product: {
        risk:
        | "low"
        | "medium"
        | "high-offshore"
        | "high-structure"
        | "high-accounts"
        | "high-service"
        | "high-freq-tx";
      };
      custom: {
        definition: string;
        risk: "low" | "medium" | "high";
      };
      overall: {
        justification: string;
        risk: "with" | "without";
      };
    };
    criteria: {
      additional: string;
    };
  }
}
