import { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm } from "./index.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_15.Form> => ({
  design: [
    {
      title:
        "Information on life insurance policies with separately managed accounts/securities accounts" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: "Contracting partner" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "contractualRelationship",
            label:
              "Name or number of the contractual relationship between the contracting party and the financial intermediary" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "insurancePolicy",
            label: "Insurance policy" as TranslatedString,
          },
        },
        {
          type: "caption",
          props: {
            label:
              "The contracting partner confirms in accordance with Art. 41a SRO Regulations that it is a licensed and state-supervised insurance company and that it has entered into the above-mentioned contractual relationship the assets connected to the life insurance policy also mentioned above." as TranslatedString,
          },
        },
        {
          type: "caption",
          props: {
            label:
              "In relation with the above insurance policy, the contracting partner gives the following further details" as TranslatedString,
          },
        },
        {
          type: "group",
          props: {
            before: "Policy holder" as TranslatedString,
            fields: [
              {
                type: "text",
                props: {
                  name: "holder.fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "holder.address",
                  label:
                    "Actual address of domicile/registered office (incl. country)" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "holder.dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "holder.nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "group",
          props: {
            before:
              "Person actually (not in a fiduciary capacity) paying the premiums (to be filled in if not identical with point 1 above)" as TranslatedString,
            fields: [
              {
                type: "text",
                props: {
                  name: "premiumPayer.fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "premiumPayer.address",
                  label:
                    "Actual address of domicile/registered office (incl. country)" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "premiumPayer.dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "premiumPayer.nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "caption",
          props: {
            label:
              "The contracting partner hereby undertakes to automatically inform the financial intermediary of any changes. The contracting partner hereby also declares having been given permission by the above individuals and/or entities to transmit their data to the financial intermediary" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: "Signature" as TranslatedString,
          },
        },
        {
          type: "caption",
          props: {
            label:
              "It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)" as TranslatedString,
          },
        },
      ],
    },
    resolutionSection(current),
  ],
});

namespace Form902_15 {
  interface Person {
    fullName: string;
    address: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
  }

  export interface Form extends BaseForm {
    contractingPartner: string;
    contractualRelationship: string;
    insurancePolicy: string;
    holder: Person;
    premiumsPayer: Person;
    signature: string;
  }
}
