import { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { BaseForm, } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm } from "./index.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_13.Form> => ({
  design: [
    {
      title: "Declaration for trusts" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: "Contracting partner" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "knownAs",
            label:
              "The undersigned hereby declare(s) that as trustee or a member of highest supervisory body of an underlying company of a trust known as" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "trust.name",
            label:
              "Name and information pertaining to the trust" as TranslatedString,
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "trust.type",
            label: "Type of trust" as TranslatedString,
            choices: [
              {
                label: "Discretionary trust" as TranslatedString,
                value: "discretionary",
              },
              {
                label: "Non-discretionary trust" as TranslatedString,
                value: "non-discretionary",
              },
            ],
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "trust.revocability",
            label: "Revocability" as TranslatedString,
            choices: [
              {
                label: "Revocable foundation" as TranslatedString,
                value: "revocable",
              },
              {
                label: "Irrevocable foundation" as TranslatedString,
                value: "irrevocable",
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Information pertaining to the (ultimate economic, not fiduciary) settlor of the trust (individual(s) or entity/ies)" as TranslatedString,
            labelField: "fullName",
            name: "settlors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "dateOfDeath",
                  label: "Date of death" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "if deceased. format 'dd/MM/yyyy'" as TranslatedString,
                  help: "if deceased'" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToRevoke",
                  required: true,
                  label:
                    "Does the founder have the right to revoke the trust?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "If the trust results from the restructuring of pre-existing trust (re-settlement) or the merger of pre-existing trusts, the following information pertaining to the (actual) settlor of the pre-existing trust(s) has to be given" as TranslatedString,
            labelField: "fullName",
            name: "preExistingSettlors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "dateOfDeath",
                  label: "Date of death" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  help: "if deceased." as TranslatedString,
                  // help: "if deceased. format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Pertaining to the beneficiary/-ies at the time of the signing of this form" as TranslatedString,
            labelField: "fullName",
            name: "beneficiaryWhenSigning",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "date",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                  pattern: "dd/MM/yyyy",
                  // help: "format 'dd/MM/yyyy'" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    "Has the beneficiary an actual right to claim distribution?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
              {
                type: "textArea",
                props: {
                  label:
                    "in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the settlor) known at the time of the signing of this form" as TranslatedString,
                  name: "beneficiaryExtra",
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Information pertaining to the protector(s) as well as (a) further person(s) having the right to revoke the trust (in case of revocable trusts) or to appoint the trustee of a trust" as TranslatedString,
            labelField: "asd",
            name: "nothing",
            fields: [],
          },
        },

        {
          type: "array",
          props: {
            label:
              "Information pertaining to the protectors" as TranslatedString,
            labelField: "fullName",
            name: "protectors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    "Does the protector have the right to revoke the trust?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Information pertaining to further persons" as TranslatedString,
            labelField: "fullName",
            name: "furtherPersons",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    "Has this further person the right to revoke the trust?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: "Signature" as TranslatedString,
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_13.Form>,
  ): FormState<Form902_13.Form> {
    return {
      settlors: {
        elements: (v.settlors ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
      protectors: {
        elements: (v.protectors ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
      furtherPersons: {
        elements: (v.furtherPersons ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
    };
  },
});

namespace Form902_13 {
  interface Foundation {
    name: string;
    type: "discretionary" | "non-discretionary";
    revocability: "revocable" | "irrevocable";
  }
  interface Person {
    fullName: string;
    address: string;
    country: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
  }
  type WithRevoke<T> = {
    rightToRevoke: "yes" | "no";
  } & T;
  type WithClaim<T> = {
    rightToClaim: "yes" | "no";
  } & T;
  type WithDeath<T> = {
    dateOfDeath: AbsoluteTime;
  } & T;

  type Founder = WithRevoke<WithDeath<Person>>;
  type Beneficiary = WithClaim<Person>;

  export interface Form extends BaseForm {
    contractingPartner: string;
    knownAs: string;
    boardMember: string;
    foundation: Foundation;
    settlors: Array<Founder>;
    preExistingSettlors: Array<Founder>;
    beneficiaryWhenSigning: Array<Beneficiary>;
    beneficiaryExtra: Array<Beneficiary>;
    protectors: Array<WithRevoke<Person>>;
    furtherPersons: Array<WithRevoke<Person>>;
  }
}
