import { AbsoluteTime, TranslatedString } from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm } from "./index.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_12.Form> => ({
  design: [
    {
      title: "Foundations" as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: "Contracting partner" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "knownAs",
            label:
              "The undersigned hereby declare(s) that as board member of the foundation, or of the highest supervisory body of an underlying company of a foundation, known as" as TranslatedString,
          },
        },
        {
          type: "text",
          props: {
            name: "foundation.name",
            label:
              "Name and information pertaining to the foundation" as TranslatedString,
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "foundation.type",
            label: "Type of foundation" as TranslatedString,
            choices: [
              {
                label: "Discretionary foundation" as TranslatedString,
                value: "discretionary",
              },
              {
                label: "Non-discretionary foundation" as TranslatedString,
                value: "non-discretionary",
              },
            ],
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "foundation.revocability",
            label: "Revocability" as TranslatedString,
            choices: [
              {
                label: "Revocable foundation" as TranslatedString,
                value: "revocable",
              },
              {
                label: "Irrevocable foundation" as TranslatedString,
                value: "irrevocable",
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Information pertaining to the (ultimate economic, not fiduciary) founder (individual(s) or entity/ies)" as TranslatedString,
            labelField: "fullName",
            name: "founders",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfDeath",
                  label: "Date of death" as TranslatedString,
                  help: "if deceased" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToRevoke",
                  required: true,
                  label:
                    "Does the founder have the right to revoke the foundation?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "If the foundation results from the restructuring of pre-existing foundation (re-settlement) or the merger of pre-existing foundations, the following information pertaining to the (actual) founder(s) of the pre-existing foundation(s) has to be given" as TranslatedString,
            labelField: "fullName",
            name: "preExistingFounders",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfDeath",
                  label: "Date of death" as TranslatedString,
                  help: "if deceased" as TranslatedString,
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Pertaining to the beneficiary/-ies at the time of the signing of this form" as TranslatedString,
            labelField: "fullName",
            name: "beneficiaryWhenSigning",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    "Has the beneficiary an actual right to claim distribution?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
              {
                type: "textArea",
                props: {
                  label:
                    "in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form" as TranslatedString,
                  name: "beneficiaryExtra",
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              "Information pertaining to further persons having the right to determine or nominate representatives (e.g.) members of the foundation board), if these representatives may dispose over the assets or have the right to change the distribution of the assets or the nomination of beneficiaries" as TranslatedString,
            labelField: "fullName",
            name: "withRightToNominate",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    "Last name(s), first name(s)/entity" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    "Actual address of domicile/registered office" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: "Country" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: "Date of birth" as TranslatedString,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: "Nationality" as TranslatedString,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    "has the person the right to revoke the foundation?" as TranslatedString,
                  choices: [
                    {
                      label: "Yes" as TranslatedString,
                      value: "yes",
                    },
                    {
                      label: "No" as TranslatedString,
                      value: "no",
                    },
                  ],
                },
              },
              {
                type: "textArea",
                props: {
                  label:
                    "in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form" as TranslatedString,
                  name: "beneficiaryExtra",
                },
              },
            ],
          },
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: "Signature" as TranslatedString,
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_12.Form>,
  ): FormState<Form902_12.Form> {
    return {
      founders: {
        elements: (v.founders ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
      withRightToNominate: {
        elements: (v.withRightToNominate ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
    };
  },
});

namespace Form902_12 {
  interface Foundation {
    name: string;
    type: "discretionary" | "non-discretionary";
    revocability: "revocable" | "irrevocable";
  }
  interface Person {
    fullName: string;
    address: string;
    country: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
  }
  type WithRevoke<T> = {
    rightToRevoke: "yes" | "no";
  } & T;
  type WithClaim<T> = {
    rightToClaim: "yes" | "no";
  } & T;
  type WithDeath<T> = {
    dateOfDeath: AbsoluteTime;
  } & T;

  type Founder = WithRevoke<WithDeath<Person>>;
  type Beneficiary = WithClaim<Person>;

  export interface Form extends BaseForm {
    contractingPartner: string;
    knownAs: string;
    boardMember: string;
    foundation: Foundation;
    founders: Array<Founder>;
    preExistingFounders: Array<Founder>;
    beneficiaryWhenSigning: Array<Beneficiary>;
    beneficiaryExtra: Array<Beneficiary>;
    withRightToNominate: Array<WithRevoke<Person>>;
  }
}
