import { TranslatedString } from "@gnu-taler/taler-util";
import { FormState } from "../handlers/FormProvider.js";
import { BaseForm } from "../pages/AntiMoneyLaunderingForm.js";
import { FlexibleForm } from "./index.js";
import { Simplest, resolutionSection } from "./simplest.js";

export const v1 = (current: BaseForm): FlexibleForm<Form902_11.Form> => ({
  design: [
    {
      title:
        "Establishing of the controlling person of operating legal entities and partnerships both not quoted on the stock exchange" as TranslatedString,
      description:
        "for operating legal entities and partnership that are contracting partner as well as analogously for operating legal entities and partnership that are beneficial owners." as TranslatedString,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: "Contracting partner" as TranslatedString,
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "declares",
            label:
              "The contracting partner hereby declares that" as TranslatedString,
            required: true,
            choices: [
              {
                label:
                  "the person(s) listed below is/are holding 25% or more of the contracting partner's shares (capital shares or voting rights)" as TranslatedString,
                value: "25-or-more",
              },
              {
                label:
                  "if the capital shares or voting rights cannot be determined or in case there are no capital shares or voting rights 25% or more, the contracting partner hereby declares that the person(s) listed below is/are controlling the contracting partner in other ways" as TranslatedString,
                value: "controlling-in-other-ways",
              },
              {
                label:
                  "in case this/these person(s) cannot be determined or this/these person(s) does/do not exist, the contracting partner hereby declares that the person(s) listed below is/are the managing director(s)" as TranslatedString,
                value: "managing-director",
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            name: "people",
            label: "People" as TranslatedString,
            required: true,
            placeholder: "this is the placeholder" as TranslatedString,
            fields: [
              {
                type: "text",
                props: {
                  name: "lastName",
                  label: "Last name(s)" as TranslatedString,
                  required: true,
                },
              },
              {
                type: "text",
                props: {
                  name: "firstName",
                  label: "First name(s)" as TranslatedString,
                  required: true,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: "Actual address of domicile" as TranslatedString,
                  required: true,
                },
              },
            ],
            labelField: "lastName",
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "fiduciaryAssets",
            label: "Fiduciary holding assets" as TranslatedString,
            help: "Is a third person the beneficial owner of the assets held in the account/securities account?" as TranslatedString,
            required: true,
            choices: [
              {
                label: "No" as TranslatedString,
                value: "no",
              },
              {
                label: "Yes" as TranslatedString,
                value: "yes",
                description:
                  "The relevant information regarding the beneficial owner has to be obtained by filling in a separate VQF doc. No. 902.9" as TranslatedString,
              },
            ],
          },
        },
      ],
    },
    resolutionSection(current),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_11.Form>,
  ): FormState<Form902_11.Form> {
    return {
      people: {
        hidden: v.declares !== "controlling-in-other-ways" &&
          v.declares !== "managing-director",
      }
    };
  }
});

namespace Form902_11 {
  interface Person {
    lastName: string;
    firstName: string;
    address: string;
  }
  export interface Form extends BaseForm {
    contractingPartner: string;
    declares: "25-or-more" | "controlling-in-other-ways" | "managing-director";
    people: Person[];
    fiduciaryAssets: "no" | "yes";
    signature: string;
  }
}
