/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { useEffect, useState } from "preact/hooks";
import { useBackendContext } from "../context/backend.js";

type Result = {
  value: boolean | undefined;
  toggle: () => Promise<void>;
};

export function useWalletDevMode(): Result {
  const [enabled, setEnabled] = useState<undefined | boolean>(undefined);
  const api = useBackendContext();
  // const { pushAlertOnError } = useAlertContext();

  async function handleOpen(): Promise<void> {
    const nextValue = !enabled;
    await api.wallet.call(WalletApiOperation.SetDevMode, {
      devModeEnabled: nextValue,
    });
    setEnabled(nextValue);
    return;
  }

  useEffect(() => {
    async function getValue(): Promise<void> {
      const res = await api.wallet.call(WalletApiOperation.GetVersion, {});
      setEnabled(res.devMode);
    }
    getValue();
  }, []);

  return {
    value: enabled,
    toggle: handleOpen,
  };
}
