/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useEffect, useState } from "preact/hooks";
import { useAlertContext } from "../context/alert.js";
import { useBackendContext } from "../context/backend.js";
import { ToggleHandler } from "../mui/handlers.js";
import { platform } from "../platform/foreground.js";

export function useClipboardPermissions(): ToggleHandler {
  const [enabled, setEnabled] = useState(false);
  const api = useBackendContext();
  const { pushAlertOnError } = useAlertContext();

  async function handleClipboardPerm(): Promise<void> {
    if (!enabled) {
      // We set permissions here, since apparently FF wants this to be done
      // as the result of an input event ...
      let granted: boolean;
      try {
        granted = await platform
          .getPermissionsApi()
          .requestClipboardPermissions();
      } catch (lastError) {
        setEnabled(false);
        throw lastError;
      }
      setEnabled(granted);
    } else {
      try {
        await api.background
          .call("toggleHeaderListener", false)
          .then((r) => setEnabled(r.newValue));
      } catch (e) {
        console.log(e);
      }
    }
    return;
  }

  useEffect(() => {
    async function getValue(): Promise<void> {
      const res = await api.background.call(
        "containsHeaderListener",
        undefined,
      );
      setEnabled(res.newValue);
    }
    getValue();
  }, []);

  return {
    value: enabled,
    button: {
      onClick: pushAlertOnError(handleClipboardPerm),
    },
  };
}
