/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { h, VNode } from "preact";
import { Amount } from "../../components/Amount.js";
import { ErrorTalerOperation } from "../../components/ErrorTalerOperation.js";
import { LogoHeader } from "../../components/LogoHeader.js";
import { Part } from "../../components/Part.js";
import { Link, SubTitle, WalletAction } from "../../components/styled/index.js";
import { Time } from "../../components/Time.js";
import { useTranslationContext } from "../../context/translation.js";
import { Button } from "../../mui/Button.js";
import { State } from "./index.js";

export function ReadyView({
  accept,
  summary,
  expiration,
  amount,
}: State.Ready): VNode {
  const { i18n } = useTranslationContext();
  return (
    <WalletAction>
      <LogoHeader />
      <SubTitle>
        <i18n.Translate>Digital cash transfer</i18n.Translate>
      </SubTitle>
      <section style={{ textAlign: "left" }}>
        <Part title={i18n.str`Subject`} text={<div>{summary}</div>} />
        <Part title={i18n.str`Amount`} text={<Amount value={amount} />} />
        <Part
          title={i18n.str`Valid until`}
          text={<Time timestamp={expiration} format="dd MMMM yyyy, HH:mm" />}
          kind="neutral"
        />
      </section>
      <section>
        <Button variant="contained" color="success" onClick={accept.onClick}>
          <i18n.Translate>
            Receive &nbsp; {<Amount value={amount} />}
          </i18n.Translate>
        </Button>
      </section>
    </WalletAction>
  );
}
