/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { css } from "@linaria/core";
import { Fragment, h, VNode } from "preact";
import { useEffect, useState } from "preact/hooks";
import { useTranslationContext } from "../context/translation.js";
import ProgressIcon from "../svg/progress.svg";
import { CenteredText } from "./styled/index.js";

const fadeIn = css`
  & {
    animation: fadein 3s;
  }
  @keyframes fadein {
    from {
      opacity: 0;
    }
    to {
      opacity: 1;
    }
  }
`;

export function Loading(): VNode {
  const { i18n } = useTranslationContext();
  return (
    <section style={{ margin: "auto" }}>
      <CenteredText class={fadeIn}>
        <i18n.Translate>Loading</i18n.Translate>...
      </CenteredText>
      {/* <div class={ripple} style={{ "--size": "250px" }}>
        <div></div>
        <div></div>
      </div> */}
      <div class={fadeIn} dangerouslySetInnerHTML={{ __html: ProgressIcon }} />
    </section>
  );
}

const ripple = css`
  & {
    display: inline-block;
    position: relative;
    width: var(--size);
    height: var(--size);
  }
  & div {
    position: absolute;
    border: 4px solid black;
    opacity: 1;
    border-radius: 50%;
    animation: lds-ripple 1s cubic-bezier(0, 0.2, 0.8, 1) infinite;
  }
  & div:nth-child(2) {
    animation-delay: -0.3s;
  }
  @keyframes lds-ripple {
    0% {
      top: calc(var(--size) / 2);
      left: calc(var(--size) / 2);
      width: 0;
      height: 0;
      opacity: 0;
    }
    14.9% {
      top: calc(var(--size) / 2);
      left: calc(var(--size) / 2);
      width: 0;
      height: 0;
      opacity: 0;
    }
    15% {
      top: calc(var(--size) / 2);
      left: calc(var(--size) / 2);
      width: 0;
      height: 0;
      opacity: 1;
    }
    100% {
      top: 0px;
      left: 0px;
      width: var(--size);
      height: var(--size);
      opacity: 0;
    }
  }
`;
