/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { setupI18n } from "@gnu-taler/taler-util";
import { parseGroupImport } from "@gnu-taler/web-util/lib/index.browser";
import { h as create } from "preact";
import { render as renderToString } from "preact-render-to-string";
import * as admin from "./paths/admin/index.stories.js";
import * as instance from "./paths/instance/index.stories.js";

setupI18n("en", { en: {} });

describe("All the examples:", () => {
  const cms = parseGroupImport({ admin, instance });
  cms.forEach((group) => {
    describe(`Example for group: ${group.title}`, () => {
      group.list.forEach((component) => {
        describe(`Component: ${component.name}`, () => {
          component.examples.forEach((example) => {
            it(`should render example: ${example.name}`, () => {
              const vdom = create(
                example.render.component,
                example.render.props,
              );
              const html = renderToString(vdom);
              // console.log(html)
            });
          });
        });
      });
    });
  });
});
