/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/*eslint quote-props: ["error", "consistent"]*/
export const strings: { [s: string]: any } = {};

strings["de"] = {
  domain: "messages",
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "",
      },
      "Access denied": [""],
      "Check your token is valid": [""],
      "Couldn't access the server.": [""],
      "Could not infer instance id from url %1$s": [""],
      "HTTP status #%1$s: Server reported a problem": [""],
      'Got message: "%1$s" from: %2$s': [""],
      "No default instance": [""],
      "in order to use merchant backoffice, you should create the default instance":
        [""],
      "Server reported a problem: HTTP status #%1$s": [""],
      "Got message: %1$s from: %2$s": [""],
      "Login required": [""],
      'Please enter your auth token. Token should have "secret-token:" and start with Bearer or ApiKey':
        [""],
      Confirm: [""],
      "The value %1$s is invalid for a payment url": [""],
      "pick a date": [""],
      clear: [""],
      never: [""],
      "Image should be smaller than 1 MB": [""],
      Country: [""],
      Address: [""],
      "Building number": [""],
      "Building name": [""],
      Street: [""],
      "Post code": [""],
      "Town location": [""],
      Town: [""],
      District: [""],
      "Country subdivision": [""],
      "Product id": [""],
      Description: [""],
      Name: [""],
      "loading...": [""],
      "no products found": [""],
      "no results": [""],
      Deleting: [""],
      Changing: [""],
      "Manage token": [""],
      Update: [""],
      Remove: [""],
      Cancel: [""],
      "Manage stock": [""],
      Infinite: [""],
      "lost cannot be greater that current + incoming (max %1$s)": [""],
      "current stock will change from %1$s to %2$s": [""],
      "current stock will stay at %1$s": [""],
      Incoming: [""],
      Lost: [""],
      Current: [""],
      "without stock": [""],
      "Next restock": [""],
      "Delivery address": [""],
      "this product has no taxes": [""],
      Amount: [""],
      "currency and value separated with colon": [""],
      Add: [""],
      Instance: [""],
      Settings: [""],
      Orders: [""],
      Products: [""],
      Transfers: [""],
      Connection: [""],
      Instances: [""],
      New: [""],
      List: [""],
      "Log out": [""],
      Clear: [""],
      "should be the same": [""],
      "cannot be the same as before": [""],
      "You are updating the authorization token from instance %1$s with id %2$s":
        [""],
      "Old token": [""],
      "New token": [""],
      "Clearing the auth token will mean public access to the instance": [""],
      ID: [""],
      Image: [""],
      Unit: [""],
      Price: [""],
      Stock: [""],
      Taxes: [""],
      "Server not found": [""],
      "Couldn't access the server": [""],
      "Got message %1$s from %2$s": [""],
      "Unexpected Error": [""],
      "Auth token": [""],
      "Account address": [""],
      "Default max deposit fee": [""],
      "Default max wire fee": [""],
      "Default wire fee amortization": [""],
      Jurisdiction: [""],
      "Default pay delay": [""],
      "Default wire transfer delay": [""],
      "could not create instance": [""],
      Delete: [""],
      Edit: [""],
      "There is no instances yet, add more pressing the + sign": [""],
      "Inventory products": [""],
      "Total price": [""],
      "Total tax": [""],
      "Order price": [""],
      Net: [""],
      Summary: [""],
      "Payments options": [""],
      "Auto refund deadline": [""],
      "Refund deadline": [""],
      "Pay deadline": [""],
      "Delivery date": [""],
      Location: [""],
      "Max fee": [""],
      "Max wire fee": [""],
      "Wire fee amortization": [""],
      "Fullfilment url": [""],
      "Extra information": [""],
      "select a product first": [""],
      "should be greater than 0": [""],
      "cannot be greater than current stock and quantity previously added. max: %1$s":
        [""],
      "cannot be greater than current stock %1$s": [""],
      Quantity: [""],
      Order: [""],
      claimed: [""],
      "copy url": [""],
      "pay at": [""],
      "created at": [""],
      Timeline: [""],
      "Payment details": [""],
      "Order status": [""],
      "Product list": [""],
      paid: [""],
      wired: [""],
      refunded: [""],
      refund: [""],
      "Refunded amount": [""],
      "Deposit total": [""],
      unpaid: [""],
      "Order status URL": [""],
      "Pay URI": [""],
      "Unknown order status. This is an error, please contact the administrator.":
        [""],
      "refund created successfully": [""],
      "could not create the refund": [""],
      "load newer orders": [""],
      Date: [""],
      Refund: [""],
      "load older orders": [""],
      "No orders has been found": [""],
      date: [""],
      amount: [""],
      reason: [""],
      "Max refundable:": [""],
      Reason: [""],
      duplicated: [""],
      "requested by the customer": [""],
      other: [""],
      "go to order id": [""],
      Paid: [""],
      Refunded: [""],
      "Not wired": [""],
      All: [""],
      "could not create product": [""],
      Sell: [""],
      Profit: [""],
      Sold: [""],
      "product updated successfully": [""],
      "could not update the product": [""],
      "product delete successfully": [""],
      "could not delete the product": [""],
      Tips: [""],
      "Committed amount": [""],
      "Exchange initial amount": [""],
      "Merchant initial amount": [""],
      "There is no tips yet, add more pressing the + sign": [""],
      "cannot be empty": [""],
      "check the id, doest look valid": [""],
      "should have 52 characters, current %1$s": [""],
      "URL doesn't have the right format": [""],
      "Transfer ID": [""],
      "Account Address": [""],
      "Exchange URL": [""],
      "could not inform transfer": [""],
      "load newer transfers": [""],
      Credit: [""],
      Confirmed: [""],
      Verified: [""],
      "Executed at": [""],
      yes: [""],
      no: [""],
      unknown: [""],
      "load older transfers": [""],
      "There is no transfer yet, add more pressing the + sign": [""],
    },
  },
};

strings["en"] = {
  domain: "messages",
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "",
      },
      "Access denied": [""],
      "Check your token is valid": [""],
      "Couldn't access the server.": [""],
      "Could not infer instance id from url %1$s": [""],
      "HTTP status #%1$s: Server reported a problem": [""],
      'Got message: "%1$s" from: %2$s': [""],
      "No default instance": [""],
      "in order to use merchant backoffice, you should create the default instance":
        [""],
      "Server reported a problem: HTTP status #%1$s": [""],
      "Got message: %1$s from: %2$s": [""],
      "Login required": [""],
      'Please enter your auth token. Token should have "secret-token:" and start with Bearer or ApiKey':
        [""],
      Confirm: [""],
      "The value %1$s is invalid for a payment url": [""],
      "pick a date": [""],
      clear: [""],
      never: [""],
      "Image should be smaller than 1 MB": [""],
      Country: [""],
      Address: [""],
      "Building number": [""],
      "Building name": [""],
      Street: [""],
      "Post code": [""],
      "Town location": [""],
      Town: [""],
      District: [""],
      "Country subdivision": [""],
      "Product id": [""],
      Description: [""],
      Name: [""],
      "loading...": [""],
      "no products found": [""],
      "no results": [""],
      Deleting: [""],
      Changing: [""],
      "Manage token": [""],
      Update: [""],
      Remove: [""],
      Cancel: [""],
      "Manage stock": [""],
      Infinite: [""],
      "lost cannot be greater that current + incoming (max %1$s)": [""],
      "current stock will change from %1$s to %2$s": [""],
      "current stock will stay at %1$s": [""],
      Incoming: [""],
      Lost: [""],
      Current: [""],
      "without stock": [""],
      "Next restock": [""],
      "Delivery address": [""],
      "this product has no taxes": [""],
      Amount: [""],
      "currency and value separated with colon": [""],
      Add: [""],
      Instance: [""],
      Settings: [""],
      Orders: [""],
      Products: [""],
      Transfers: [""],
      Connection: [""],
      Instances: [""],
      New: [""],
      List: [""],
      "Log out": [""],
      Clear: [""],
      "should be the same": [""],
      "cannot be the same as before": [""],
      "You are updating the authorization token from instance %1$s with id %2$s":
        [""],
      "Old token": [""],
      "New token": [""],
      "Clearing the auth token will mean public access to the instance": [""],
      ID: [""],
      Image: [""],
      Unit: [""],
      Price: [""],
      Stock: [""],
      Taxes: [""],
      "Server not found": [""],
      "Couldn't access the server": [""],
      "Got message %1$s from %2$s": [""],
      "Unexpected Error": [""],
      "Auth token": [""],
      "Account address": [""],
      "Default max deposit fee": [""],
      "Default max wire fee": [""],
      "Default wire fee amortization": [""],
      Jurisdiction: [""],
      "Default pay delay": [""],
      "Default wire transfer delay": [""],
      "could not create instance": [""],
      Delete: [""],
      Edit: [""],
      "There is no instances yet, add more pressing the + sign": [""],
      "Inventory products": [""],
      "Total price": [""],
      "Total tax": [""],
      "Order price": [""],
      Net: [""],
      Summary: [""],
      "Payments options": [""],
      "Auto refund deadline": [""],
      "Refund deadline": [""],
      "Pay deadline": [""],
      "Delivery date": [""],
      Location: [""],
      "Max fee": [""],
      "Max wire fee": [""],
      "Wire fee amortization": [""],
      "Fullfilment url": [""],
      "Extra information": [""],
      "select a product first": [""],
      "should be greater than 0": [""],
      "cannot be greater than current stock and quantity previously added. max: %1$s":
        [""],
      "cannot be greater than current stock %1$s": [""],
      Quantity: [""],
      Order: [""],
      claimed: [""],
      "copy url": [""],
      "pay at": [""],
      "created at": [""],
      Timeline: [""],
      "Payment details": [""],
      "Order status": [""],
      "Product list": [""],
      paid: [""],
      wired: [""],
      refunded: [""],
      refund: [""],
      "Refunded amount": [""],
      "Deposit total": [""],
      unpaid: [""],
      "Order status URL": [""],
      "Pay URI": [""],
      "Unknown order status. This is an error, please contact the administrator.":
        [""],
      "refund created successfully": [""],
      "could not create the refund": [""],
      "load newer orders": [""],
      Date: [""],
      Refund: [""],
      "load older orders": [""],
      "No orders has been found": [""],
      date: [""],
      amount: [""],
      reason: [""],
      "Max refundable:": [""],
      Reason: [""],
      duplicated: [""],
      "requested by the customer": [""],
      other: [""],
      "go to order id": [""],
      Paid: [""],
      Refunded: [""],
      "Not wired": [""],
      All: [""],
      "could not create product": [""],
      Sell: [""],
      Profit: [""],
      Sold: [""],
      "product updated successfully": [""],
      "could not update the product": [""],
      "product delete successfully": [""],
      "could not delete the product": [""],
      Tips: [""],
      "Committed amount": [""],
      "Exchange initial amount": [""],
      "Merchant initial amount": [""],
      "There is no tips yet, add more pressing the + sign": [""],
      "cannot be empty": [""],
      "check the id, doest look valid": [""],
      "should have 52 characters, current %1$s": [""],
      "URL doesn't have the right format": [""],
      "Transfer ID": [""],
      "Account Address": [""],
      "Exchange URL": [""],
      "could not inform transfer": [""],
      "load newer transfers": [""],
      Credit: [""],
      Confirmed: [""],
      Verified: [""],
      "Executed at": [""],
      yes: [""],
      no: [""],
      unknown: [""],
      "load older transfers": [""],
      "There is no transfer yet, add more pressing the + sign": [""],
    },
  },
};

strings["es"] = {
  domain: "messages",
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "",
      },
      "Access denied": ["Acceso denegado"],
      "Check your token is valid": ["Verifica que el token sea valido"],
      "Couldn't access the server.": ["No se pudo acceder al servidor"],
      "Could not infer instance id from url %1$s": [
        "No se pudo inferir el id de la instancia con la url %1$s",
      ],
      "HTTP status #%1$s: Server reported a problem": [
        "HTTP status #%1$s: Servidor reporto un problema",
      ],
      'Got message: "%1$s" from: %2$s': [
        "Recivimos el mensaje %1$s desde %2$s",
      ],
      "No default instance": ["Sin instancia default"],
      "in order to use merchant backoffice, you should create the default instance":
        [
          "para usar el merchant backoffice, debería crear la instancia default",
        ],
      "Server reported a problem: HTTP status #%1$s": [
        "Servidir reporto un problema: HTTP status #%1$s",
      ],
      "Got message: %1$s from: %2$s": ["Recivimos el mensaje %1$s desde %2$s"],
      "Login required": ["Login necesario"],
      'Please enter your auth token. Token should have "secret-token:" and start with Bearer or ApiKey':
        [
          'Por favor ingrese su token de autorización. El token debe tener "secret-token" y comenzar con Bearer o ApiKey',
        ],
      Confirm: ["Confirmar"],
      "The value %1$s is invalid for a payment url": [
        "El valor %1$s es invalido para una URL de pago",
      ],
      "pick a date": ["elegir una fecha"],
      clear: ["Limpiar"],
      never: ["nunca"],
      "Image should be smaller than 1 MB": [
        "La imagen debe ser mas chica que 1 MB",
      ],
      Country: ["País"],
      Address: ["Dirección"],
      "Building number": ["Número de edificio"],
      "Building name": ["Nombre de edificio"],
      Street: ["Calle"],
      "Post code": ["Código postal"],
      "Town location": ["Ubicación de ciudad"],
      Town: ["Ciudad"],
      District: ["Distrito"],
      "Country subdivision": ["Provincia"],
      "Product id": ["Id de producto"],
      Description: ["Descripcion"],
      Name: ["Nombre"],
      "loading...": ["Cargando..."],
      "no products found": ["No se encontraron productos"],
      "no results": ["Sin resultados"],
      Deleting: ["Borrando"],
      Changing: ["Cambiando"],
      "Manage token": ["Administrar token"],
      Update: ["Actualizar"],
      Remove: ["Eliminar"],
      Cancel: ["Cancelar"],
      "Manage stock": ["Administrar stock"],
      Infinite: ["Inifinito"],
      "lost cannot be greater that current + incoming (max %1$s)": [
        "no puede ser mayor al stock actual %1$s",
      ],
      "current stock will change from %1$s to %2$s": [
        "stock actual cambiará desde %1$s a %2$s",
      ],
      "current stock will stay at %1$s": ["stock actual seguirá en %1$s"],
      Incoming: ["Ingresando"],
      Lost: ["Perdido"],
      Current: ["Actual"],
      "without stock": ["sin stock"],
      "Next restock": ["Próximo reabastecimiento"],
      "Delivery address": ["Dirección de entrega"],
      "this product has no taxes": ["este producto no tiene impuestos"],
      Amount: ["Monto"],
      "currency and value separated with colon": [
        "Moneda y valor separado por dos puntos",
      ],
      Add: ["Agregar"],
      Instance: ["Instancia"],
      Settings: ["Configuración"],
      Orders: ["Ordenes"],
      Products: ["Productos"],
      Transfers: ["Transferencias"],
      Connection: ["Conexión"],
      Instances: ["Instancias"],
      New: ["Nuevo"],
      List: ["Lista"],
      "Log out": ["Salir"],
      Clear: ["Limpiar"],
      "should be the same": ["deberían ser iguales"],
      "cannot be the same as before": ["no puede ser igual al anterior"],
      "You are updating the authorization token from instance %1$s with id %2$s":
        [
          "Está actualizando el token de autorización para la instancia %1$s con id %2$s",
        ],
      "Old token": ["Viejo token"],
      "New token": ["Nuevo token"],
      "Clearing the auth token will mean public access to the instance": [
        "Limpiar el token de autorización significa acceso publico a la instancia",
      ],
      ID: ["ID"],
      Image: ["Imagen"],
      Unit: ["Unidad"],
      Price: ["Precio"],
      Stock: ["Stock"],
      Taxes: ["Impuesto"],
      "Server not found": ["Servidor no encontrado"],
      "Couldn't access the server": ["No se pudo aceder al servidor"],
      "Got message %1$s from %2$s": ["Recivimos el mensaje %1$s desde %2$s"],
      "Unexpected Error": ["Error inesperado"],
      "Auth token": ["Token de autorización"],
      "Account address": ["Dirección de cuenta"],
      "Default max deposit fee": ["Impuesto máximo de deposito por omisión"],
      "Default max wire fee": ["Impuesto máximo de transferencia por omisión"],
      "Default wire fee amortization": [
        "Amortización de impuesto de transferencia por omisión",
      ],
      Jurisdiction: ["Jurisdicción"],
      "Default pay delay": ["Retrazo de pago por omisión"],
      "Default wire transfer delay": ["Retrazo de transferencia por omisión"],
      "could not create instance": ["no se pudo crear la instancia"],
      Delete: ["Borrando"],
      Edit: [""],
      "There is no instances yet, add more pressing the + sign": [
        "No hay instancias todavían, agregue mas presionando el signo +",
      ],
      "Inventory products": ["Productos de inventario"],
      "Total price": ["Precio total"],
      "Total tax": ["Impuesto total"],
      "Order price": ["Precio de la orden"],
      Net: ["Neto"],
      Summary: ["Resumen"],
      "Payments options": ["Opciones de pago"],
      "Auto refund deadline": ["Plazo de reembolso automático"],
      "Refund deadline": ["Plazo de reembolso"],
      "Pay deadline": ["Plazo de pago"],
      "Delivery date": ["Fecha de entrega"],
      Location: ["Ubicación"],
      "Max fee": ["Impuesto máximo"],
      "Max wire fee": ["Impuesto de transferencia máximo"],
      "Wire fee amortization": ["Amortización de impuesto de transferencia"],
      "Fullfilment url": ["URL de completitud"],
      "Extra information": ["Información extra"],
      "select a product first": ["seleccione un producto primero"],
      "should be greater than 0": ["La imagen debe ser mas chica que 1 MB"],
      "cannot be greater than current stock and quantity previously added. max: %1$s":
        [
          "no puede ser mayor al stock actual y la cantidad previamente agregada. máximo: %1$s",
        ],
      "cannot be greater than current stock %1$s": [
        "no puede ser mayor al stock actual %1$s",
      ],
      Quantity: ["Cantidad"],
      Order: ["Orden"],
      claimed: ["reclamado"],
      "copy url": ["copiar url"],
      "pay at": ["pagar en"],
      "created at": ["creado"],
      Timeline: ["Cronología"],
      "Payment details": ["Detalles de pago"],
      "Order status": ["Estado de orden"],
      "Product list": ["Lista de producto"],
      paid: ["pagados"],
      wired: ["transferido"],
      refunded: ["reembolzado"],
      refund: ["reembolzar"],
      "Refunded amount": ["Monto reembolzado"],
      "Deposit total": ["Total depositado"],
      unpaid: ["impago"],
      "Order status URL": ["URL de estado de orden"],
      "Pay URI": ["URI de pago"],
      "Unknown order status. This is an error, please contact the administrator.":
        [
          "Estado de orden desconocido. Esto es un error, por favor contacte a su administrador",
        ],
      "refund created successfully": ["reembolzo creado satisfactoriamente"],
      "could not create the refund": ["No se pudo aceder al servidor"],
      "load newer orders": ["cargar nuevas ordenes"],
      Date: ["Fecha"],
      Refund: ["Reembolzar"],
      "load older orders": ["cargar viejas ordenes"],
      "No orders has been found": ["No se enconraron ordenes"],
      date: ["fecha"],
      amount: ["monto"],
      reason: ["razón"],
      "Max refundable:": ["Máximo reembolzable:"],
      Reason: ["Razón"],
      duplicated: ["duplicado"],
      "requested by the customer": ["pedido por el consumidor"],
      other: ["otro"],
      "go to order id": ["ir a id de orden"],
      Paid: ["Pagado"],
      Refunded: ["Reembolzado"],
      "Not wired": ["No transferido"],
      All: ["Todo"],
      "could not create product": ["no se pudo crear el producto"],
      Sell: ["Venta"],
      Profit: ["Ganancia"],
      Sold: ["Vendido"],
      "product updated successfully": ["producto actualizado correctamente"],
      "could not update the product": ["no se pudo actualizar el producto"],
      "product delete successfully": ["producto fue eliminado correctamente"],
      "could not delete the product": ["no se pudo eliminar el producto"],
      Tips: ["Propinas"],
      "Committed amount": [""],
      "Exchange initial amount": [""],
      "Merchant initial amount": [""],
      "There is no tips yet, add more pressing the + sign": [
        "No hay propinas todavía, agregar mas presionando el signo +",
      ],
      "cannot be empty": ["no puede ser vacío"],
      "check the id, doest look valid": ["verificar el id, no parece válido"],
      "should have 52 characters, current %1$s": [
        "debería tener 52 caracteres, actualmente %1$s",
      ],
      "URL doesn't have the right format": [
        "La URL no tiene el formato correcto",
      ],
      "Transfer ID": ["Transferencias"],
      "Account Address": ["Dirección de cuenta"],
      "Exchange URL": ["URL del Exchange"],
      "could not inform transfer": ["no se pudo crear la instancia"],
      "load newer transfers": ["cargar nuevas ordenes"],
      Credit: ["Crédito"],
      Confirmed: ["Confirmar"],
      Verified: ["Verificado"],
      "Executed at": ["creado"],
      yes: ["si"],
      no: ["no"],
      unknown: ["desconocido"],
      "load older transfers": ["cargar viejas transferencias"],
      "There is no transfer yet, add more pressing the + sign": [
        "No hay transferencias todavía, agregar mas presionando el signo +",
      ],
    },
  },
};

strings["fr"] = {
  domain: "messages",
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "",
      },
      "Access denied": [""],
      "Check your token is valid": [""],
      "Couldn't access the server.": [""],
      "Could not infer instance id from url %1$s": [""],
      "HTTP status #%1$s: Server reported a problem": [""],
      'Got message: "%1$s" from: %2$s': [""],
      "No default instance": [""],
      "in order to use merchant backoffice, you should create the default instance":
        [""],
      "Server reported a problem: HTTP status #%1$s": [""],
      "Got message: %1$s from: %2$s": [""],
      "Login required": [""],
      'Please enter your auth token. Token should have "secret-token:" and start with Bearer or ApiKey':
        [""],
      Confirm: [""],
      "The value %1$s is invalid for a payment url": [""],
      "pick a date": [""],
      clear: [""],
      never: [""],
      "Image should be smaller than 1 MB": [""],
      Country: [""],
      Address: [""],
      "Building number": [""],
      "Building name": [""],
      Street: [""],
      "Post code": [""],
      "Town location": [""],
      Town: [""],
      District: [""],
      "Country subdivision": [""],
      "Product id": [""],
      Description: [""],
      Name: [""],
      "loading...": [""],
      "no products found": [""],
      "no results": [""],
      Deleting: [""],
      Changing: [""],
      "Manage token": [""],
      Update: [""],
      Remove: [""],
      Cancel: [""],
      "Manage stock": [""],
      Infinite: [""],
      "lost cannot be greater that current + incoming (max %1$s)": [""],
      "current stock will change from %1$s to %2$s": [""],
      "current stock will stay at %1$s": [""],
      Incoming: [""],
      Lost: [""],
      Current: [""],
      "without stock": [""],
      "Next restock": [""],
      "Delivery address": [""],
      "this product has no taxes": [""],
      Amount: [""],
      "currency and value separated with colon": [""],
      Add: [""],
      Instance: [""],
      Settings: [""],
      Orders: [""],
      Products: [""],
      Transfers: [""],
      Connection: [""],
      Instances: [""],
      New: [""],
      List: [""],
      "Log out": [""],
      Clear: [""],
      "should be the same": [""],
      "cannot be the same as before": [""],
      "You are updating the authorization token from instance %1$s with id %2$s":
        [""],
      "Old token": [""],
      "New token": [""],
      "Clearing the auth token will mean public access to the instance": [""],
      ID: [""],
      Image: [""],
      Unit: [""],
      Price: [""],
      Stock: [""],
      Taxes: [""],
      "Server not found": [""],
      "Couldn't access the server": [""],
      "Got message %1$s from %2$s": [""],
      "Unexpected Error": [""],
      "Auth token": [""],
      "Account address": [""],
      "Default max deposit fee": [""],
      "Default max wire fee": [""],
      "Default wire fee amortization": [""],
      Jurisdiction: [""],
      "Default pay delay": [""],
      "Default wire transfer delay": [""],
      "could not create instance": [""],
      Delete: [""],
      Edit: [""],
      "There is no instances yet, add more pressing the + sign": [""],
      "Inventory products": [""],
      "Total price": [""],
      "Total tax": [""],
      "Order price": [""],
      Net: [""],
      Summary: [""],
      "Payments options": [""],
      "Auto refund deadline": [""],
      "Refund deadline": [""],
      "Pay deadline": [""],
      "Delivery date": [""],
      Location: [""],
      "Max fee": [""],
      "Max wire fee": [""],
      "Wire fee amortization": [""],
      "Fullfilment url": [""],
      "Extra information": [""],
      "select a product first": [""],
      "should be greater than 0": [""],
      "cannot be greater than current stock and quantity previously added. max: %1$s":
        [""],
      "cannot be greater than current stock %1$s": [""],
      Quantity: [""],
      Order: [""],
      claimed: [""],
      "copy url": [""],
      "pay at": [""],
      "created at": [""],
      Timeline: [""],
      "Payment details": [""],
      "Order status": [""],
      "Product list": [""],
      paid: [""],
      wired: [""],
      refunded: [""],
      refund: [""],
      "Refunded amount": [""],
      "Deposit total": [""],
      unpaid: [""],
      "Order status URL": [""],
      "Pay URI": [""],
      "Unknown order status. This is an error, please contact the administrator.":
        [""],
      "refund created successfully": [""],
      "could not create the refund": [""],
      "load newer orders": [""],
      Date: [""],
      Refund: [""],
      "load older orders": [""],
      "No orders has been found": [""],
      date: [""],
      amount: [""],
      reason: [""],
      "Max refundable:": [""],
      Reason: [""],
      duplicated: [""],
      "requested by the customer": [""],
      other: [""],
      "go to order id": [""],
      Paid: [""],
      Refunded: [""],
      "Not wired": [""],
      All: [""],
      "could not create product": [""],
      Sell: [""],
      Profit: [""],
      Sold: [""],
      "product updated successfully": [""],
      "could not update the product": [""],
      "product delete successfully": [""],
      "could not delete the product": [""],
      Tips: [""],
      "Committed amount": [""],
      "Exchange initial amount": [""],
      "Merchant initial amount": [""],
      "There is no tips yet, add more pressing the + sign": [""],
      "cannot be empty": [""],
      "check the id, doest look valid": [""],
      "should have 52 characters, current %1$s": [""],
      "URL doesn't have the right format": [""],
      "Transfer ID": [""],
      "Account Address": [""],
      "Exchange URL": [""],
      "could not inform transfer": [""],
      "load newer transfers": [""],
      Credit: [""],
      Confirmed: [""],
      Verified: [""],
      "Executed at": [""],
      yes: [""],
      no: [""],
      unknown: [""],
      "load older transfers": [""],
      "There is no transfer yet, add more pressing the + sign": [""],
    },
  },
};

strings["it"] = {
  domain: "messages",
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "",
      },
      "Access denied": [""],
      "Check your token is valid": [""],
      "Couldn't access the server.": [""],
      "Could not infer instance id from url %1$s": [""],
      "HTTP status #%1$s: Server reported a problem": [""],
      'Got message: "%1$s" from: %2$s': [""],
      "No default instance": [""],
      "in order to use merchant backoffice, you should create the default instance":
        [""],
      "Server reported a problem: HTTP status #%1$s": [""],
      "Got message: %1$s from: %2$s": [""],
      "Login required": [""],
      'Please enter your auth token. Token should have "secret-token:" and start with Bearer or ApiKey':
        [""],
      Confirm: [""],
      "The value %1$s is invalid for a payment url": [""],
      "pick a date": [""],
      clear: [""],
      never: [""],
      "Image should be smaller than 1 MB": [""],
      Country: [""],
      Address: [""],
      "Building number": [""],
      "Building name": [""],
      Street: [""],
      "Post code": [""],
      "Town location": [""],
      Town: [""],
      District: [""],
      "Country subdivision": [""],
      "Product id": [""],
      Description: [""],
      Name: [""],
      "loading...": [""],
      "no products found": [""],
      "no results": [""],
      Deleting: [""],
      Changing: [""],
      "Manage token": [""],
      Update: [""],
      Remove: [""],
      Cancel: [""],
      "Manage stock": [""],
      Infinite: [""],
      "lost cannot be greater that current + incoming (max %1$s)": [""],
      "current stock will change from %1$s to %2$s": [""],
      "current stock will stay at %1$s": [""],
      Incoming: [""],
      Lost: [""],
      Current: [""],
      "without stock": [""],
      "Next restock": [""],
      "Delivery address": [""],
      "this product has no taxes": [""],
      Amount: [""],
      "currency and value separated with colon": [""],
      Add: [""],
      Instance: [""],
      Settings: [""],
      Orders: [""],
      Products: [""],
      Transfers: [""],
      Connection: [""],
      Instances: [""],
      New: [""],
      List: [""],
      "Log out": [""],
      Clear: [""],
      "should be the same": [""],
      "cannot be the same as before": [""],
      "You are updating the authorization token from instance %1$s with id %2$s":
        [""],
      "Old token": [""],
      "New token": [""],
      "Clearing the auth token will mean public access to the instance": [""],
      ID: [""],
      Image: [""],
      Unit: [""],
      Price: [""],
      Stock: [""],
      Taxes: [""],
      "Server not found": [""],
      "Couldn't access the server": [""],
      "Got message %1$s from %2$s": [""],
      "Unexpected Error": [""],
      "Auth token": [""],
      "Account address": [""],
      "Default max deposit fee": [""],
      "Default max wire fee": [""],
      "Default wire fee amortization": [""],
      Jurisdiction: [""],
      "Default pay delay": [""],
      "Default wire transfer delay": [""],
      "could not create instance": [""],
      Delete: [""],
      Edit: [""],
      "There is no instances yet, add more pressing the + sign": [""],
      "Inventory products": [""],
      "Total price": [""],
      "Total tax": [""],
      "Order price": [""],
      Net: [""],
      Summary: [""],
      "Payments options": [""],
      "Auto refund deadline": [""],
      "Refund deadline": [""],
      "Pay deadline": [""],
      "Delivery date": [""],
      Location: [""],
      "Max fee": [""],
      "Max wire fee": [""],
      "Wire fee amortization": [""],
      "Fullfilment url": [""],
      "Extra information": [""],
      "select a product first": [""],
      "should be greater than 0": [""],
      "cannot be greater than current stock and quantity previously added. max: %1$s":
        [""],
      "cannot be greater than current stock %1$s": [""],
      Quantity: [""],
      Order: [""],
      claimed: [""],
      "copy url": [""],
      "pay at": [""],
      "created at": [""],
      Timeline: [""],
      "Payment details": [""],
      "Order status": [""],
      "Product list": [""],
      paid: [""],
      wired: [""],
      refunded: [""],
      refund: [""],
      "Refunded amount": [""],
      "Deposit total": [""],
      unpaid: [""],
      "Order status URL": [""],
      "Pay URI": [""],
      "Unknown order status. This is an error, please contact the administrator.":
        [""],
      "refund created successfully": [""],
      "could not create the refund": [""],
      "load newer orders": [""],
      Date: [""],
      Refund: [""],
      "load older orders": [""],
      "No orders has been found": [""],
      date: [""],
      amount: [""],
      reason: [""],
      "Max refundable:": [""],
      Reason: [""],
      duplicated: [""],
      "requested by the customer": [""],
      other: [""],
      "go to order id": [""],
      Paid: [""],
      Refunded: [""],
      "Not wired": [""],
      All: [""],
      "could not create product": [""],
      Sell: [""],
      Profit: [""],
      Sold: [""],
      "product updated successfully": [""],
      "could not update the product": [""],
      "product delete successfully": [""],
      "could not delete the product": [""],
      Tips: [""],
      "Committed amount": [""],
      "Exchange initial amount": [""],
      "Merchant initial amount": [""],
      "There is no tips yet, add more pressing the + sign": [""],
      "cannot be empty": [""],
      "check the id, doest look valid": [""],
      "should have 52 characters, current %1$s": [""],
      "URL doesn't have the right format": [""],
      "Transfer ID": [""],
      "Account Address": [""],
      "Exchange URL": [""],
      "could not inform transfer": [""],
      "load newer transfers": [""],
      Credit: [""],
      Confirmed: [""],
      Verified: [""],
      "Executed at": [""],
      yes: [""],
      no: [""],
      unknown: [""],
      "load older transfers": [""],
      "There is no transfer yet, add more pressing the + sign": [""],
    },
  },
};

strings["sv"] = {
  domain: "messages",
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "",
      },
      "Access denied": [""],
      "Check your token is valid": [""],
      "Couldn't access the server.": [""],
      "Could not infer instance id from url %1$s": [""],
      "HTTP status #%1$s: Server reported a problem": [""],
      'Got message: "%1$s" from: %2$s': [""],
      "No default instance": [""],
      "in order to use merchant backoffice, you should create the default instance":
        [""],
      "Server reported a problem: HTTP status #%1$s": [""],
      "Got message: %1$s from: %2$s": [""],
      "Login required": [""],
      'Please enter your auth token. Token should have "secret-token:" and start with Bearer or ApiKey':
        [""],
      Confirm: [""],
      "The value %1$s is invalid for a payment url": [""],
      "pick a date": [""],
      clear: [""],
      never: [""],
      "Image should be smaller than 1 MB": [""],
      Country: [""],
      Address: [""],
      "Building number": [""],
      "Building name": [""],
      Street: [""],
      "Post code": [""],
      "Town location": [""],
      Town: [""],
      District: [""],
      "Country subdivision": [""],
      "Product id": [""],
      Description: [""],
      Name: [""],
      "loading...": [""],
      "no products found": [""],
      "no results": [""],
      Deleting: [""],
      Changing: [""],
      "Manage token": [""],
      Update: [""],
      Remove: [""],
      Cancel: [""],
      "Manage stock": [""],
      Infinite: [""],
      "lost cannot be greater that current + incoming (max %1$s)": [""],
      "current stock will change from %1$s to %2$s": [""],
      "current stock will stay at %1$s": [""],
      Incoming: [""],
      Lost: [""],
      Current: [""],
      "without stock": [""],
      "Next restock": [""],
      "Delivery address": [""],
      "this product has no taxes": [""],
      Amount: [""],
      "currency and value separated with colon": [""],
      Add: [""],
      Instance: [""],
      Settings: [""],
      Orders: [""],
      Products: [""],
      Transfers: [""],
      Connection: [""],
      Instances: [""],
      New: [""],
      List: [""],
      "Log out": [""],
      Clear: [""],
      "should be the same": [""],
      "cannot be the same as before": [""],
      "You are updating the authorization token from instance %1$s with id %2$s":
        [""],
      "Old token": [""],
      "New token": [""],
      "Clearing the auth token will mean public access to the instance": [""],
      ID: [""],
      Image: [""],
      Unit: [""],
      Price: [""],
      Stock: [""],
      Taxes: [""],
      "Server not found": [""],
      "Couldn't access the server": [""],
      "Got message %1$s from %2$s": [""],
      "Unexpected Error": [""],
      "Auth token": [""],
      "Account address": [""],
      "Default max deposit fee": [""],
      "Default max wire fee": [""],
      "Default wire fee amortization": [""],
      Jurisdiction: [""],
      "Default pay delay": [""],
      "Default wire transfer delay": [""],
      "could not create instance": [""],
      Delete: [""],
      Edit: [""],
      "There is no instances yet, add more pressing the + sign": [""],
      "Inventory products": [""],
      "Total price": [""],
      "Total tax": [""],
      "Order price": [""],
      Net: [""],
      Summary: [""],
      "Payments options": [""],
      "Auto refund deadline": [""],
      "Refund deadline": [""],
      "Pay deadline": [""],
      "Delivery date": [""],
      Location: [""],
      "Max fee": [""],
      "Max wire fee": [""],
      "Wire fee amortization": [""],
      "Fullfilment url": [""],
      "Extra information": [""],
      "select a product first": [""],
      "should be greater than 0": [""],
      "cannot be greater than current stock and quantity previously added. max: %1$s":
        [""],
      "cannot be greater than current stock %1$s": [""],
      Quantity: [""],
      Order: [""],
      claimed: [""],
      "copy url": [""],
      "pay at": [""],
      "created at": [""],
      Timeline: [""],
      "Payment details": [""],
      "Order status": [""],
      "Product list": [""],
      paid: [""],
      wired: [""],
      refunded: [""],
      refund: [""],
      "Refunded amount": [""],
      "Deposit total": [""],
      unpaid: [""],
      "Order status URL": [""],
      "Pay URI": [""],
      "Unknown order status. This is an error, please contact the administrator.":
        [""],
      "refund created successfully": [""],
      "could not create the refund": [""],
      "load newer orders": [""],
      Date: [""],
      Refund: [""],
      "load older orders": [""],
      "No orders has been found": [""],
      date: [""],
      amount: [""],
      reason: [""],
      "Max refundable:": [""],
      Reason: [""],
      duplicated: [""],
      "requested by the customer": [""],
      other: [""],
      "go to order id": [""],
      Paid: [""],
      Refunded: [""],
      "Not wired": [""],
      All: [""],
      "could not create product": [""],
      Sell: [""],
      Profit: [""],
      Sold: [""],
      "product updated successfully": [""],
      "could not update the product": [""],
      "product delete successfully": [""],
      "could not delete the product": [""],
      Tips: [""],
      "Committed amount": [""],
      "Exchange initial amount": [""],
      "Merchant initial amount": [""],
      "There is no tips yet, add more pressing the + sign": [""],
      "cannot be empty": [""],
      "check the id, doest look valid": [""],
      "should have 52 characters, current %1$s": [""],
      "URL doesn't have the right format": [""],
      "Transfer ID": [""],
      "Account Address": [""],
      "Exchange URL": [""],
      "could not inform transfer": [""],
      "load newer transfers": [""],
      Credit: [""],
      Confirmed: [""],
      Verified: [""],
      "Executed at": [""],
      yes: [""],
      no: [""],
      unknown: [""],
      "load older transfers": [""],
      "There is no transfer yet, add more pressing the + sign": [""],
    },
  },
};
