/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { Query } from "@gnu-taler/web-util/lib/tests/mock";
import { MerchantBackend } from "../declaration.js";

////////////////////
// ORDER
////////////////////

export const API_CREATE_ORDER: Query<
  MerchantBackend.Orders.PostOrderRequest,
  MerchantBackend.Orders.PostOrderResponse
> = {
  method: "POST",
  url: "http://backend/instances/default/private/orders",
};

export const API_GET_ORDER_BY_ID = (
  id: string,
): Query<unknown, MerchantBackend.Orders.MerchantOrderStatusResponse> => ({
  method: "GET",
  url: `http://backend/instances/default/private/orders/${id}`,
});

export const API_LIST_ORDERS: Query<
  unknown,
  MerchantBackend.Orders.OrderHistory
> = {
  method: "GET",
  url: "http://backend/instances/default/private/orders",
};

export const API_REFUND_ORDER_BY_ID = (
  id: string,
): Query<
  MerchantBackend.Orders.RefundRequest,
  MerchantBackend.Orders.MerchantRefundResponse
> => ({
  method: "POST",
  url: `http://backend/instances/default/private/orders/${id}/refund`,
});

export const API_FORGET_ORDER_BY_ID = (
  id: string,
): Query<MerchantBackend.Orders.ForgetRequest, unknown> => ({
  method: "PATCH",
  url: `http://backend/instances/default/private/orders/${id}/forget`,
});

export const API_DELETE_ORDER = (
  id: string,
): Query<MerchantBackend.Orders.ForgetRequest, unknown> => ({
  method: "DELETE",
  url: `http://backend/instances/default/private/orders/${id}`,
});

////////////////////
// TRANSFER
////////////////////

export const API_LIST_TRANSFERS: Query<
  unknown,
  MerchantBackend.Transfers.TransferList
> = {
  method: "GET",
  url: "http://backend/instances/default/private/transfers",
};

export const API_INFORM_TRANSFERS: Query<
  MerchantBackend.Transfers.TransferInformation,
  MerchantBackend.Transfers.MerchantTrackTransferResponse
> = {
  method: "POST",
  url: "http://backend/instances/default/private/transfers",
};

////////////////////
// PRODUCT
////////////////////

export const API_CREATE_PRODUCT: Query<
  MerchantBackend.Products.ProductAddDetail,
  unknown
> = {
  method: "POST",
  url: "http://backend/instances/default/private/products",
};

export const API_LIST_PRODUCTS: Query<
  unknown,
  MerchantBackend.Products.InventorySummaryResponse
> = {
  method: "GET",
  url: "http://backend/instances/default/private/products",
};

export const API_GET_PRODUCT_BY_ID = (
  id: string,
): Query<unknown, MerchantBackend.Products.ProductDetail> => ({
  method: "GET",
  url: `http://backend/instances/default/private/products/${id}`,
});

export const API_UPDATE_PRODUCT_BY_ID = (
  id: string,
): Query<
  MerchantBackend.Products.ProductPatchDetail,
  MerchantBackend.Products.InventorySummaryResponse
> => ({
  method: "PATCH",
  url: `http://backend/instances/default/private/products/${id}`,
});

export const API_DELETE_PRODUCT = (id: string): Query<unknown, unknown> => ({
  method: "DELETE",
  url: `http://backend/instances/default/private/products/${id}`,
});

////////////////////
// RESERVES
////////////////////

export const API_CREATE_RESERVE: Query<
  MerchantBackend.Tips.ReserveCreateRequest,
  MerchantBackend.Tips.ReserveCreateConfirmation
> = {
  method: "POST",
  url: "http://backend/instances/default/private/reserves",
};
export const API_LIST_RESERVES: Query<
  unknown,
  MerchantBackend.Tips.TippingReserveStatus
> = {
  method: "GET",
  url: "http://backend/instances/default/private/reserves",
};

export const API_GET_RESERVE_BY_ID = (
  pub: string,
): Query<unknown, MerchantBackend.Tips.ReserveDetail> => ({
  method: "GET",
  url: `http://backend/instances/default/private/reserves/${pub}`,
});

export const API_GET_TIP_BY_ID = (
  pub: string,
): Query<unknown, MerchantBackend.Tips.TipDetails> => ({
  method: "GET",
  url: `http://backend/instances/default/private/tips/${pub}`,
});

export const API_AUTHORIZE_TIP_FOR_RESERVE = (
  pub: string,
): Query<
  MerchantBackend.Tips.TipCreateRequest,
  MerchantBackend.Tips.TipCreateConfirmation
> => ({
  method: "POST",
  url: `http://backend/instances/default/private/reserves/${pub}/authorize-tip`,
});

export const API_AUTHORIZE_TIP: Query<
  MerchantBackend.Tips.TipCreateRequest,
  MerchantBackend.Tips.TipCreateConfirmation
> = {
  method: "POST",
  url: `http://backend/instances/default/private/tips`,
};

export const API_DELETE_RESERVE = (id: string): Query<unknown, unknown> => ({
  method: "DELETE",
  url: `http://backend/instances/default/private/reserves/${id}`,
});

////////////////////
// INSTANCE ADMIN
////////////////////

export const API_CREATE_INSTANCE: Query<
  MerchantBackend.Instances.InstanceConfigurationMessage,
  unknown
> = {
  method: "POST",
  url: "http://backend/management/instances",
};

export const API_GET_INSTANCE_BY_ID = (
  id: string,
): Query<unknown, MerchantBackend.Instances.QueryInstancesResponse> => ({
  method: "GET",
  url: `http://backend/management/instances/${id}`,
});

export const API_GET_INSTANCE_KYC_BY_ID = (
  id: string,
): Query<unknown, MerchantBackend.Instances.AccountKycRedirects> => ({
  method: "GET",
  url: `http://backend/management/instances/${id}/kyc`,
});

export const API_LIST_INSTANCES: Query<
  unknown,
  MerchantBackend.Instances.InstancesResponse
> = {
  method: "GET",
  url: "http://backend/management/instances",
};

export const API_UPDATE_INSTANCE_BY_ID = (
  id: string,
): Query<
  MerchantBackend.Instances.InstanceReconfigurationMessage,
  unknown
> => ({
  method: "PATCH",
  url: `http://backend/management/instances/${id}`,
});

export const API_UPDATE_INSTANCE_AUTH_BY_ID = (
  id: string,
): Query<
  MerchantBackend.Instances.InstanceAuthConfigurationMessage,
  unknown
> => ({
  method: "POST",
  url: `http://backend/management/instances/${id}/auth`,
});

export const API_DELETE_INSTANCE = (id: string): Query<unknown, unknown> => ({
  method: "DELETE",
  url: `http://backend/management/instances/${id}`,
});

////////////////////
// INSTANCE
////////////////////

export const API_GET_CURRENT_INSTANCE: Query<
  unknown,
  MerchantBackend.Instances.QueryInstancesResponse
> = {
  method: "GET",
  url: `http://backend/instances/default/private/`,
};

export const API_GET_CURRENT_INSTANCE_KYC: Query<
  unknown,
  MerchantBackend.Instances.AccountKycRedirects
> = {
  method: "GET",
  url: `http://backend/instances/default/private/kyc`,
};

export const API_UPDATE_CURRENT_INSTANCE: Query<
  MerchantBackend.Instances.InstanceReconfigurationMessage,
  unknown
> = {
  method: "PATCH",
  url: `http://backend/instances/default/private/`,
};

export const API_UPDATE_CURRENT_INSTANCE_AUTH: Query<
  MerchantBackend.Instances.InstanceAuthConfigurationMessage,
  unknown
> = {
  method: "POST",
  url: `http://backend/instances/default/private/auth`,
};

export const API_DELETE_CURRENT_INSTANCE: Query<unknown, unknown> = {
  method: "DELETE",
  url: `http://backend/instances/default/private`,
};
