/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { ComponentChildren, createContext, h, VNode } from "preact";
import { useContext } from "preact/hooks";
import { defaultRequestHandler } from "../utils/request.js";

interface Type {
  request: typeof defaultRequestHandler;
}

const Context = createContext<Type>({
  request: defaultRequestHandler,
});

export const useApiContext = (): Type => useContext(Context);
export const ApiContextProvider = ({
  children,
  value,
}: {
  value: Type;
  children: ComponentChildren;
}): VNode => {
  return h(Context.Provider, { value, children });
};
