/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { Fragment, h, VNode } from "preact";
import { BackendContextProvider } from "./context/backend";
import { TranslationProvider } from "./context/translation";
// import { Page as RequestPayment } from './RequestPayment';
import { Route, Router } from "preact-router";
import { Footer } from "./components/Footer";
import "./css/pure-min.css";

export default function Application(): VNode {
  return (
    // <FetchContextProvider>
    <BackendContextProvider>
      <TranslationProvider>
        <ApplicationStatusRoutes />
      </TranslationProvider>
    </BackendContextProvider>
    // </FetchContextProvider>
  );
}

function ApplicationStatusRoutes(): VNode {
  return (
    <Fragment>
      <Router>
        <Route default component={() => <div>hello!</div>} />
      </Router>
      <Footer />
    </Fragment>
  );
}
