/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/*eslint quote-props: ["error", "consistent"]*/
export const strings: { [s: string]: any } = {};

strings["de"] = {
  domain: "messages",
  locale_data: {
    messages: {
      days: [""],
      hours: [""],
      minutes: [""],
      seconds: [""],
      Clear: [""],
      Logout: [""],
      "Demo Bank": [""],
      "Go back": [""],
      "Wire transfer": [""],
      "Transfer money to another account of this bank:": [""],
      "Want to try the raw payto://-format?": [""],
      "Transfer money via the Payto system:": [""],
      "payto address": [""],
      Confirm: [""],
      "Confirm Withdrawal": [""],
      "Waiting the bank to create the operaion...": [""],
      "This withdrawal was aborted!": [""],
      "Withdraw to a Taler Wallet": [""],
      "You can use this QR code to withdraw to your mobile wallet:": [""],
      "this link": [""],
      Abort: [""],
      "Start withdrawal": [""],
      "Withdraw Money into a Taler wallet": [""],
      "Amount to withdraw": [""],
      "Please login!": [""],
      Login: [""],
      "Register to the euFin bank!": [""],
      "Registration form": [""],
      Register: [""],
      Date: [""],
      Amount: [""],
      Counterpart: [""],
      Subject: [""],
      "Username or account label '%1$s' not found.  Won't login.": [""],
      "Wrong credentials given.": [""],
      "Account information could not be retrieved.": [""],
      "Close wire transfer": [""],
      "Close Taler withdrawal": [""],
      "Bank account balance:": [""],
      "Latest transactions:": [""],
      "Transfer money manually": [""],
      "List of public accounts was not found.": [""],
      "List of public accounts could not be retrieved.": [""],
      "History of public accounts": [""],
      "Page has a problem: logged in but backend state is lost.": [""],
      "Welcome to the euFin bank!": [""],
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "de",
      },
    },
  },
};

strings["en"] = {
  domain: "messages",
  locale_data: {
    messages: {
      days: ["days"],
      hours: ["hours"],
      minutes: ["minutes"],
      seconds: ["seconds"],
      Clear: [""],
      Logout: [""],
      "Demo Bank": [""],
      "Go back": ["Go back"],
      "Wire transfer": [""],
      "Transfer money to another account of this bank:": [""],
      "Want to try the raw payto://-format?": [""],
      "Transfer money via the Payto system:": [""],
      "payto address": [""],
      Confirm: [""],
      "Confirm Withdrawal": ["Confirm withdrawal"],
      "Waiting the bank to create the operaion...": [""],
      "This withdrawal was aborted!": [""],
      "Withdraw to a Taler Wallet": ["Charge Taler wallet"],
      "You can use this QR code to withdraw to your mobile wallet:": [""],
      "this link": [""],
      Abort: [""],
      "Start withdrawal": ["Start withdrawal"],
      "Withdraw Money into a Taler wallet": ["Charge Taler wallet"],
      "Amount to withdraw": ["Amount to withdraw"],
      "Please login!": [""],
      Login: [""],
      "Register to the euFin bank!": [""],
      "Registration form": [""],
      Register: [""],
      Date: [""],
      Amount: [""],
      Counterpart: [""],
      Subject: [""],
      "Username or account label '%1$s' not found.  Won't login.": [""],
      "Wrong credentials given.": [""],
      "Account information could not be retrieved.": [""],
      "Close wire transfer": [""],
      "Close Taler withdrawal": ["Close Taler withdrawal"],
      "Bank account balance:": [""],
      "Latest transactions:": [""],
      "Transfer money manually": [""],
      "List of public accounts was not found.": [""],
      "List of public accounts could not be retrieved.": [""],
      "History of public accounts": [""],
      "Page has a problem: logged in but backend state is lost.": [
        "Page has a problem: logged in but backend state is lost.",
      ],
      "Welcome to the euFin bank!": [
        "Welcome to euFin bank: Taler+IBAN now possible!",
      ],
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "en",
      },
    },
  },
};

strings["it"] = {
  domain: "messages",
  locale_data: {
    messages: {
      days: [""],
      hours: [""],
      minutes: [""],
      seconds: [""],
      Clear: ["Cancella"],
      Logout: [""],
      "Demo Bank": ["Banca 'demo'"],
      "Go back": ["Indietro"],
      "Wire transfer": ["Bonifico"],
      "Transfer money to another account of this bank:": [
        "Trasferisci fondi a un altro conto di questa banca:",
      ],
      "Want to try the raw payto://-format?": [
        "Prova il trasferimento tramite il formato Payto!",
      ],
      "Transfer money via the Payto system:": [
        "Effettua un bonifico tramite il sistema Payto:",
      ],
      "payto address": ["indirizzo Payto"],
      Confirm: ["Conferma"],
      "Confirm Withdrawal": ["Conferma il ritiro"],
      "Waiting the bank to create the operaion...": [
        "La banca sta creando l'operazione...",
      ],
      "This withdrawal was aborted!": ["Questo ritiro è stato annullato!"],
      "Withdraw to a Taler Wallet": ["Ritira contante nel portafoglio Taler"],
      "You can use this QR code to withdraw to your mobile wallet:": [
        "Usa questo codice QR per ritirare contante nel tuo wallet:",
      ],
      "this link": ["questo link"],
      Abort: ["Annulla"],
      "Start withdrawal": ["Ritira contante"],
      "Withdraw Money into a Taler wallet": [
        "Ritira contante nel portafoglio Taler",
      ],
      "Amount to withdraw": ["Somma da ritirare"],
      "Please login!": ["Accedi!"],
      Login: ["Accedi"],
      "Register to the euFin bank!": ["Apri un conto in banca euFin!"],
      "Registration form": ["Registrazione"],
      Register: ["Registrati"],
      Date: [""],
      Amount: ["Somma"],
      Counterpart: ["Controparte"],
      Subject: ["Causale"],
      "Username or account label '%1$s' not found.  Won't login.": [
        "L'utente '%1$s' non esiste.  Login impossibile",
      ],
      "Wrong credentials given.": ["Credenziali invalide."],
      "Account information could not be retrieved.": [
        "Impossibile ricevere le informazioni relative al conto.",
      ],
      "Close wire transfer": ["Chiudi il bonifico"],
      "Close Taler withdrawal": ["Chiudi il ritiro Taler"],
      "Bank account balance:": ["Bilancio:"],
      "Latest transactions:": ["Ultime transazioni:"],
      "Transfer money manually": ["Effettua un bonifico"],
      "List of public accounts was not found.": [
        "Lista conti pubblici non trovata.",
      ],
      "List of public accounts could not be retrieved.": [
        "Lista conti pubblici non pervenuta.",
      ],
      "History of public accounts": ["Storico dei conti pubblici"],
      "Page has a problem: logged in but backend state is lost.": [
        "Stato inconsistente: accesso utente effettuato ma stato con server perso.",
      ],
      "Welcome to the euFin bank!": ["Benvenuti in banca euFin!"],
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=(n != 1);",
        lang: "it",
      },
    },
  },
};
