/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { AmountJson, Amounts, TranslatedString } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import {
  FlexibleForm,
  DefaultForm as TestedComponent,
} from "./DefaultForm.js";

export default {
  title: "Input Amount",
};

export namespace Simplest {
  export interface Form {
    comment: string;
  }
}

type TargetObject = {
  amount: AmountJson;
}
const initial: TargetObject = {
  amount: Amounts.parseOrThrow("USD:10")
}

const form: FlexibleForm<TargetObject> = {
  design: [{
    title: "this is a simple form" as TranslatedString,
    fields: [{
      type: "amount",
      props: {
        label: "label of the field" as TranslatedString,
        name: "amount",
      },
    }]
  }]
}

export const SimpleComment = tests.createExample(TestedComponent, { initial, form });
