/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { Part } from "../../components/Part.js";
import { PaymentButtons } from "../../components/PaymentButtons.js";
import { Time } from "../../components/Time.js";
import {
  getAmountWithFee,
  InvoicePaymentDetails,
} from "../../wallet/Transaction.js";
import { State } from "./index.js";

export function ReadyView(
  state: State.Ready | State.NoBalanceForCurrency | State.NoEnoughBalance,
): VNode {
  const { i18n } = useTranslationContext();
  const { summary, effective, raw, expiration, uri, status, payStatus } = state;
  return (
    <Fragment>
      <section style={{ textAlign: "left" }}>
        <Part title={i18n.str`Subject`} text={<div>{summary}</div>} />
        <Part
          title={i18n.str`Details`}
          text={
            <InvoicePaymentDetails
              amount={getAmountWithFee(effective, raw, "debit")}
            />
          }
        />
        <Part
          title={i18n.str`Valid until`}
          text={<Time timestamp={expiration} format="dd MMMM yyyy, HH:mm" />}
          kind="neutral"
        />
      </section>
      <PaymentButtons
        amount={effective}
        payStatus={payStatus}
        uri={uri}
        payHandler={status === "ready" ? state.accept : undefined}
        goToWalletManualWithdraw={state.goToWalletManualWithdraw}
      />
    </Fragment>
  );
}
