// @ts-ignore
import * as _qjsOsImp from "os";
// @ts-ignore
import * as _qjsStdImp from "std";

export interface QjsHttpResp {
  status: number;
  data: ArrayBuffer;
  headers?: string[];
}

export interface QjsHttpOptions {
  method: string;
  debug?: boolean;
  data?: ArrayBuffer;
  headers?: string[];
}

export interface QjsOsLib {
  fetchHttp(url: string, options?: QjsHttpOptions): Promise<QjsHttpResp>;
  postMessageToHost(s: string): void;
  setMessageFromHostHandler(h: (s: string) => void): void;
  rename(oldPath: string, newPath: string): number;
  remove(path: string): number;
}

export interface QjsStdLib {
  writeFile(filename: string, contents: string): void;
  loadFile(filename: string): string;
}

// This is not the nodejs "os" module, but the qjs "os" module.
export const qjsOs: QjsOsLib = _qjsOsImp as any;

export const qjsStd: QjsStdLib = _qjsStdImp as any;
