#!/bin/bash
# This file is in the public domain.

# After the compilation succeeded
# some changes needs to be made
# in the html/js files to match the
# what the service expects

cd dist/prod

for file in *.html; do

  # 1. remove the js reference used for dev
  sed /main.js/d -i $file

  # 2. change the location of css since 
  #challenger backend wants them in the root path
  sed 's/="main.css"/="..\/main.css"/' -i $file

  # 3. rename the extension to must template
  mv $file ${file:0:-5}.en.must
done

#delete unused files
rm *.js *.map
